/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin;

import com.urbancode.air.plugin.PluginExecutionException;
import com.urbancode.air.securedata.BadEnvelopeException;
import com.urbancode.air.securedata.Base64Codec;
import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.SecretContainerImpl;
import com.urbancode.air.securedata.SecureBlob;
import com.urbancode.commons.util.IO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.Properties;

public class Main {
    private static final String UCD_ENCRYPT_PROPERTIES_ENV_VAR = "UCD_USE_ENCRYPTED_PROPERTIES";
    private static final String UCD_SECRET_VAR = "ucd.properties.secret";
    private final String[] args;
    private boolean hasReadStdInProps = false;
    private String secret = null;

    public static void main(String[] args) {
        System.exit(new Main(args).execute());
    }

    private Main(String[] args) {
        this.args = args;
    }

    private int execute() {
        int result = 0;
        try {
            if (this.args.length != 3) {
                throw new PluginExecutionException("Unexpected number of plugin arguments. Expected arguments: Command class name, input properties file, output properties file");
            }
            String commandClassName = this.args[0];
            String inputPropertiesPath = this.args[1];
            String outputPropertiesPath = this.args[2];
            File inputPropertiesFile = new File(inputPropertiesPath);
            Properties inputProperties = this.loadInputProperties(inputPropertiesFile);
            Properties outputProperties = new Properties();
            Class<?> commandClass = null;
            String fullClassName = this.getClass().getPackage().getName() + ".command." + commandClassName;
            try {
                commandClass = Class.forName(fullClassName);
            }
            catch (ClassNotFoundException e) {
                throw new PluginExecutionException("No class found at " + fullClassName);
            }
            Constructor<?> constructor = null;
            try {
                constructor = commandClass.getConstructor(Properties.class, Properties.class);
            }
            catch (NoSuchMethodException e) {
                throw new PluginExecutionException("No constructor found for class " + commandClass + " matching signature: public " + commandClass.getSimpleName() + "(Properties inputProperties, Properties outputProperties)");
            }
            Object commandInstance = constructor.newInstance(inputProperties, outputProperties);
            Method executeMethod = null;
            try {
                executeMethod = commandClass.getMethod("execute", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new PluginExecutionException("No method found in class " + commandClass + " matching signature: public int execute()");
            }
            if (executeMethod.getReturnType() != Integer.TYPE && executeMethod.getReturnType() != Integer.class) {
                throw new PluginExecutionException("execute() method in class " + commandClass + " does not return type int or Integer.");
            }
            result = (Integer)executeMethod.invoke(commandInstance, new Object[0]);
            File outputPropertiesFile = new File(outputPropertiesPath);
            this.writeProperties(outputProperties, outputPropertiesFile);
        }
        catch (PluginExecutionException e) {
            System.out.println(e.getMessage());
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = 1;
        }
        return result;
    }

    private String getSecret() throws IOException {
        if (this.hasReadStdInProps) {
            return this.secret;
        }
        boolean useEnc = Boolean.valueOf(System.getenv(UCD_ENCRYPT_PROPERTIES_ENV_VAR));
        Properties props = new Properties();
        if (useEnc) {
            props.load(System.in);
            this.secret = props.getProperty(UCD_SECRET_VAR);
            this.hasReadStdInProps = true;
        }
        return this.secret;
    }

    private Properties loadInputProperties(File inputPropsFile) throws PluginExecutionException, IOException {
        String encSecret = this.getSecret();
        Properties inputProperties = null;
        try {
            FileInputStream inputPropertiesStream = new FileInputStream(inputPropsFile);
            if (encSecret == null) {
                inputProperties = this.loadProperties(inputPropertiesStream);
            } else {
                SecretContainerImpl secret = new SecretContainerImpl(new Base64Codec().decodeFromString(encSecret));
                inputProperties = this.loadEncryptedProperties((SecretContainer)secret, inputPropertiesStream);
            }
        }
        catch (IOException e) {
            throw new PluginExecutionException("Could not locate input properties file at " + inputPropsFile.getAbsolutePath());
        }
        return inputProperties;
    }

    private Properties loadEncryptedProperties(SecretContainer secret, InputStream inStream) throws IOException {
        try {
            SecureBlob blob = SecureBlob.fromEncryptedBytes((SecretContainer)secret, (byte[])IO.read((InputStream)inStream));
            return this.loadProperties(new ByteArrayInputStream(blob.get()));
        }
        catch (BadEnvelopeException e) {
            throw new IOException("Couldn't read encrypted properties file", e);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Couldn't read encrypted properties file", e);
        }
    }

    private Properties loadProperties(InputStream inStream) throws IOException {
        Properties props = new Properties();
        try {
            props.load(inStream);
        }
        finally {
            IO.close((InputStream)inStream);
        }
        return props;
    }

    private void writeProperties(Properties props, File outputFile) throws IOException {
        String encSecret = this.getSecret();
        FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
        if (encSecret == null) {
            this.writeProperties(props, fileOutputStream);
        } else {
            SecretContainerImpl secret = new SecretContainerImpl(new Base64Codec().decodeFromString(encSecret));
            this.writeEncryptedProperties(props, fileOutputStream, (SecretContainer)secret);
        }
    }

    private void writeEncryptedProperties(Properties props, OutputStream str, SecretContainer secret) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeProperties(props, baos);
        try {
            SecureBlob blob = SecureBlob.fromUnencryptedBytes((SecretContainer)secret, (byte[])baos.toByteArray());
            str.write(blob.getEncryptedBytes());
        }
        catch (BadEnvelopeException e) {
            throw new IOException("Couldn't write encrypted properties file", e);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Couldn't write encrypted properties file", e);
        }
        finally {
            IO.close((OutputStream)str);
        }
    }

    private void writeProperties(Properties props, OutputStream str) throws IOException {
        try {
            props.store(str, "");
        }
        finally {
            IO.close((OutputStream)str);
        }
    }
}

