/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.SystemClient;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.codehaus.jettison.json.JSONObject;

public class SendEmail {
    private static final String SMTP_EXAMPLE_COM = "smtp.example.com";
    private static final String SEND_ADDRESS_EXAMPLE = "sender@example.com";
    private final Properties inputProperties;

    public SendEmail(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() throws Exception {
        Session lSession;
        String toAddress = this.inputProperties.getProperty("toList");
        String subject = this.inputProperties.getProperty("subject");
        String message = this.inputProperties.getProperty("message");
        String attachment = this.inputProperties.getProperty("attachment");
        String host = this.inputProperties.getProperty("host").trim();
        String port = this.inputProperties.getProperty("port").trim();
        String secure = this.inputProperties.getProperty("secure");
        String fromAddress = this.inputProperties.getProperty("fromAddress").trim();
        final String username = this.inputProperties.getProperty("username").trim();
        final String password = this.inputProperties.getProperty("password");
        XTrustProvider.install();
        if (host.isEmpty() || port.isEmpty() || "none".equals(secure) || fromAddress.isEmpty()) {
            System.out.println("[Ok] Retrieving Host, Port, TLS Security and Sender Email Address from the Deploy server's General Settings.");
            String udUser = "PasswordIsAuthToken";
            String udPass = System.getenv("AUTH_TOKEN");
            String weburl = System.getenv("AH_WEB_URL");
            SystemClient client = new SystemClient(new URI(weburl), udUser, udPass);
            JSONObject json = client.getSystemConfiguration();
            HashMap<Object, String> values = new HashMap<Object, String>();
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                values.put(key, json.getString(key));
            }
            for (Map.Entry entry : values.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                switch (key) {
                    case "deployMailHost": {
                        host = value;
                        break;
                    }
                    case "deployMailPort": {
                        port = value;
                        break;
                    }
                    case "deployMailSecure": {
                        secure = value;
                        break;
                    }
                    case "deployMailSender": {
                        fromAddress = value;
                    }
                }
            }
        }
        if (SMTP_EXAMPLE_COM.equals(host) || SEND_ADDRESS_EXAMPLE.equals(fromAddress)) {
            throw new RuntimeException("[Error] Mail Server Settings have not been set. Confirm the settings have been configured in IBM UrbanCode Deploy's General Settings.");
        }
        StringTokenizer tok = new StringTokenizer(toAddress, ",");
        ArrayList<InternetAddress> emailTos = new ArrayList<InternetAddress>();
        while (tok.hasMoreElements()) {
            emailTos.add(new InternetAddress(tok.nextElement().toString()));
        }
        Properties mprops = new Properties();
        mprops.put("mail.smtp.host", host);
        mprops.put("mail.smtp.port", port);
        mprops.put("mail.smtp.starttls.enable", secure);
        if (!username.isEmpty() && !password.isEmpty()) {
            mprops.put("mail.smtp.auth", "true");
            lSession = Session.getInstance((Properties)mprops, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
        } else {
            lSession = Session.getDefaultInstance((Properties)mprops, null);
        }
        MimeMessage msg = new MimeMessage(lSession);
        msg.setRecipients(Message.RecipientType.TO, (Address[])emailTos.toArray(new InternetAddress[0]));
        msg.setFrom((Address)new InternetAddress(fromAddress));
        msg.setSubject(subject);
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(message);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (attachment != null && !attachment.trim().isEmpty()) {
            File file = new File(attachment);
            if (file.exists()) {
                messageBodyPart = new MimeBodyPart();
                FileDataSource fileDataSource = new FileDataSource(file);
                messageBodyPart.setDataHandler(new DataHandler(fileDataSource));
                messageBodyPart.setFileName(file.getName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
            } else {
                throw new IllegalArgumentException("Attachment File does not exist");
            }
        }
        msg.setContent((Multipart)multipart);
        msg.setHeader("Content-Type", multipart.getContentType());
        Transport.send((Message)msg);
        System.out.println("Email(s) sent!");
        return 0;
    }
}

