/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.MalformedChallengeException;

public abstract class RFC2617Scheme
implements AuthScheme {
    private Map params = null;

    public RFC2617Scheme() {
    }

    public RFC2617Scheme(String string) throws MalformedChallengeException {
        this.processChallenge(string);
    }

    @Override
    public void processChallenge(String string) throws MalformedChallengeException {
        String string2 = AuthChallengeParser.extractScheme(string);
        if (!string2.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid " + this.getSchemeName() + " challenge: " + string);
        }
        this.params = AuthChallengeParser.extractParams(string);
    }

    protected Map getParameters() {
        return this.params;
    }

    @Override
    public String getParameter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        if (this.params == null) {
            return null;
        }
        return (String)this.params.get(string.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getRealm() {
        return this.getParameter("realm");
    }

    @Override
    public String getID() {
        return this.getRealm();
    }
}

