/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonOld

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

def changeRequestSysId
def taskList
def badStatus  = [:]
def changeRequestId = props['changeRequestId']
def status = props['status']


println "Checking request with number ${changeRequestId}"
println "Checking for status ${status}"
println ""

HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airTool)
def newAPI = helper.checkAPI()


if (newAPI)
{
    changeRequestSysId = helper.getChangeRequestSysId()
    taskList = helper.getTaskList(changeRequestSysId)

    if (taskList.result.size() == 0) {
        println "No tasks were found for Change Request ${changeRequestId}. Exiting failure."
        System.exit(1)
    }

    for (def task : taskList.result) {
        if (Integer.valueOf(task.state) != Integer.valueOf(status)) {
            badStatus.put(task.number, task.state)
        }
        else {
            println "Task " + task.number + " matches status ${status}!"
        }
    }
}
else
{
    HelperRestClientJsonOld helperOld = new HelperRestClientJsonOld(airTool)
    changeRequestSysId = helperOld.getChangeRequestSysId()
    taskList = helperOld.getTaskList(changeRequestSysId)

    if (taskList.records.size() == 0) {
        println "No tasks were found for Change Request ${changeRequestId}. Exiting failure."
        System.exit(1)
    }

    for (def task : taskList.records) {
        if (Integer.valueOf(task.state) != Integer.valueOf(status)) {
            badStatus.put(task.number, task.state)
        }
        else {
            println "Task " + task.number + " matches status ${status}!"
        }
    }
}

if (!badStatus.isEmpty()) {
    println ""
    println "Not all tasks matched status ${status}"
    badStatus.each { badStat ->
        println "TaskName : " + badStat.getKey();
        println "Status : " + badStat.getValue();
    }
    System.exit(1)
}

System.exit(0)