/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonOld

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

Integer reportedStatus
def changeRequestId = props['changeRequestId']
def status = props['status']

println "Checking request with number ${changeRequestId}"
println "Checking for approval status ${status}"
println ""

HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airTool)
def newAPI = helper.checkAPI()

if (newAPI) {
    reportedStatus = helper.getStatus()
}
else {
    HelperRestClientJsonOld helperOld = new HelperRestClientJsonOld(airTool)
    reportedStatus = helperOld.getStatus()
}

if (reportedStatus != Integer.valueOf(status)) {
    println "Reported status, ${reportedStatus} is not equal to ${status}!"
    System.exit(1)
}
else {
    println "Reported status matches requested status, ${status}!";
    System.exit(0);
}