/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonOld

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

def tasksIds = props['tasksId']
def status = props['status']

println "Updating task Ids with number ${tasksIds}"
println "Updating with status ${status}"
println ""

HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airTool)
def newAPI = helper.checkAPI()

if (newAPI) {
    tasksIds.split(',').each { taskId ->
       helper.setTaskStatus(taskId, status)
       println ""
    }
}
else {
    HelperRestClientJsonOld helperOld = new HelperRestClientJsonOld(airTool)
    tasksIds.split(',').each { taskId ->
       helperOld.setTaskStatus(taskId, status)
       println ""
    }
}


println ""

println "All task statuses updated to ${status}!"
System.exit(0)
