/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.idl.types;

import java.util.Map;
import java.util.TreeMap;
import org.apache.axis2.corba.idl.types.CompositeDataType;
import org.apache.axis2.corba.idl.types.Interface;

public class IDL {
    private Map compositeDataTypes;
    private Map interfaces;

    public Map getCompositeDataTypes() {
        return this.compositeDataTypes;
    }

    public void setCompositeDataTypes(Map compositeDataTypes) {
        this.compositeDataTypes = compositeDataTypes;
    }

    public void addType(CompositeDataType dataType) {
        if (this.compositeDataTypes == null) {
            this.compositeDataTypes = new TreeMap();
        }
        this.compositeDataTypes.put(dataType.getModule() + dataType.getName(), dataType);
    }

    public Map getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Map interfaces) {
        this.interfaces = interfaces;
        if (this.compositeDataTypes == null) {
            this.compositeDataTypes = new TreeMap();
        }
        this.compositeDataTypes.putAll(interfaces);
    }

    public void addInterface(Interface intf) {
        if (this.interfaces == null) {
            this.interfaces = new TreeMap();
        }
        this.interfaces.put(intf.getModule() + intf.getName(), intf);
        if (this.compositeDataTypes == null) {
            this.compositeDataTypes = new TreeMap();
        }
        this.compositeDataTypes.put(intf.getModule() + intf.getName(), intf);
    }

    public void addIDL(IDL childIdl) {
        Map temp = childIdl.getInterfaces();
        if (temp != null) {
            if (this.interfaces == null) {
                this.interfaces = new TreeMap();
            }
            this.interfaces.putAll(temp);
        }
        if ((temp = childIdl.getCompositeDataTypes()) != null) {
            if (this.compositeDataTypes == null) {
                this.compositeDataTypes = new TreeMap();
            }
            this.compositeDataTypes.putAll(temp);
        }
    }
}

