/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.ApiSelector
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonOld

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

def status = props['status']
def tasksIds = props['tasksId']

println "Updating task Ids with number ${tasksIds}"
println "Updating with status ${status}"
println ""

def newAPI = ApiSelector.selectApi(airTool)

if (newAPI) {
    HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airTool)

    tasksIds.split(',').each { taskId ->
       helper.setTaskStatus(taskId, status)
       println ""
    }
}
else {
    HelperRestClientJsonOld helperOld = new HelperRestClientJsonOld(airTool)

    tasksIds.split(',').each { taskId ->
       helperOld.setTaskStatus(taskId, status)
       println ""
    }
}


println ""
println "All task statuses updated to ${status}!"

System.exit(0)