/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class TransportHeaders
implements Map {
    HttpServletRequest req;
    HashMap headerMap = null;
    HashMap localHeaderMap = new HashMap();

    public TransportHeaders(HttpServletRequest req) {
        this.req = req;
    }

    private void init() {
        this.headerMap = new HashMap();
        Enumeration headerNames = this.req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = this.req.getHeader(key);
            this.headerMap.put(key, value);
        }
        Set localHeaderSet = this.localHeaderMap.entrySet();
        Iterator localHeaderIterator = localHeaderSet.iterator();
        while (localHeaderIterator.hasNext()) {
            Map.Entry localHeaderEntry = localHeaderIterator.next();
            this.headerMap.put(localHeaderEntry.getKey(), localHeaderEntry.getValue());
        }
        this.localHeaderMap = null;
    }

    public int size() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.size();
    }

    public void clear() {
        if (this.headerMap != null) {
            this.headerMap.clear();
        }
        if (this.localHeaderMap != null) {
            this.localHeaderMap.clear();
        }
    }

    public boolean isEmpty() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.containsValue(value);
    }

    public Collection values() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.values();
    }

    public void putAll(Map t) {
        if (this.headerMap == null) {
            this.init();
        }
        this.headerMap.putAll(t);
    }

    public Set entrySet() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.entrySet();
    }

    public Set keySet() {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.keySet();
    }

    public Object get(Object key) {
        if (this.localHeaderMap != null) {
            Object returnValue = null;
            returnValue = this.localHeaderMap.get(key);
            if (returnValue != null) {
                return returnValue;
            }
        }
        if (this.headerMap == null) {
            return this.req.getHeader((String)key);
        }
        return this.headerMap.get(key);
    }

    public Object remove(Object key) {
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.remove(key);
    }

    public Object put(Object key, Object value) {
        if (this.localHeaderMap != null) {
            return this.localHeaderMap.put(key, value);
        }
        if (this.headerMap == null) {
            this.init();
        }
        return this.headerMap.put(key, value);
    }
}

