/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.CommonHiddenStreamToken;
import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.JavaNodeFactory;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.PrinterState;
import de.hunsicker.jalopy.printer.WriterCache;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import de.hunsicker.util.StringHelper;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class NodeWriter
extends Writer {
    public static final boolean INDENT_NO = false;
    public static final boolean INDENT_YES = true;
    public static final boolean NEWLINE_NO = false;
    public static final boolean NEWLINE_YES = true;
    static final int MODE_DEFAULT = 1;
    static final int MODE_TEST = 2;
    private static final String LCURLY = "{".intern();
    private static final String RCURLY = "}".intern();
    private static final String TAB = "\t".intern();
    private static final String EMPTY_STRING = "".intern();
    protected Convention settings;
    protected Environment environment;
    protected String lineSeparator;
    protected String originalLineSeparator;
    protected boolean continuation;
    protected boolean footer;
    protected boolean insertTrailingEmpty;
    protected boolean leftBraceNewline;
    protected boolean newline = true;
    protected boolean nextNewline = false;
    protected boolean useLeadingTabs;
    protected boolean useTabs;
    protected int column = 1;
    protected int continuationIndentSize;
    protected int indentSize;
    protected int last = 70;
    protected int leftBraceIndent;
    protected int line = 1;
    protected int mode = 1;
    CommonHiddenStreamToken pendingComment;
    JavaNode expression;
    Map issues;
    PrinterState state = new PrinterState(this);
    String filename = "<unknown>";
    WriterCache testers;
    boolean tracking;
    int blankLines;
    int indentLevel;
    int leadingIndentSize;
    private String _leadingIndentSizeString;
    private String _rightBrace;
    private Writer _out;
    private char[] _indentChars;
    private CompositeFactory _factory = null;
    public int javadocIndent = 0;

    public NodeWriter(Writer out, CompositeFactory factory, String filename, Map issues, String lineSeparator, String originalLineSeparator) {
        this(factory);
        this.filename = filename;
        this.issues = issues;
        this.lineSeparator = lineSeparator;
        this.originalLineSeparator = originalLineSeparator;
        this.testers = new WriterCache(factory, this);
        this._out = out;
    }

    public CompositeFactory getCompositeFactory() {
        return this._factory;
    }

    public JavaNodeFactory getJavaNodeFactory() {
        return this._factory.getJavaNodeFactory();
    }

    protected NodeWriter(CompositeFactory factory) {
        this._factory = factory;
        this.lineSeparator = File.separator;
        this.settings = Convention.getInstance();
        this.indentSize = AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE, 4);
        this.insertTrailingEmpty = AbstractPrinter.settings.getBoolean(ConventionKeys.INSERT_TRAILING_NEWLINE, true);
        this.continuationIndentSize = AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_CONTINUATION, 4);
        this.leftBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false);
        this.leftBraceIndent = AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_LEFT, 1);
        this.leadingIndentSize = AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_LEADING, 0);
        this.useTabs = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_WITH_TABS, false);
        this.useLeadingTabs = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_WITH_TABS_ONLY_LEADING, false);
        this.footer = AbstractPrinter.settings.getBoolean(ConventionKeys.FOOTER, false);
        this._indentChars = new char[150];
        int i = 0;
        while (i < this._indentChars.length) {
            this._indentChars[i] = 32;
            ++i;
        }
        if (this.leadingIndentSize > 0) {
            this._leadingIndentSizeString = this.getString(this.leadingIndentSize);
            if (this.useTabs) {
                this._leadingIndentSizeString = StringHelper.replace(this._leadingIndentSizeString, this.getString(this.indentSize), TAB);
            }
        }
    }

    public int getColumn() {
        return this.column;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getIndentLength() {
        return this.indentLevel * this.indentSize;
    }

    public void setIndentLevel(int level) {
        this.indentLevel = level;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public void setLast(int type) {
        this.last = type;
    }

    public int getLast() {
        return this.last;
    }

    public int getLine() {
        return this.line;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getString(int length) {
        return this.generateIndentString(length);
    }

    public void setTracking(boolean tracking) {
        this.tracking = tracking;
    }

    public void setWriter(Writer out) {
        this._out = out;
    }

    public void close() throws IOException {
        this.settings = null;
        this.issues = null;
        this.state.dispose();
        this.state = null;
        this._out.close();
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public void indent() {
        this.setIndentLevel(this.indentLevel + 1);
    }

    public int print(String string, int type) throws IOException {
        int offset = 1;
        if (this.newline) {
            if (this.leadingIndentSize > 0) {
                this._out.write(this._leadingIndentSizeString);
                this.column += this.leadingIndentSize;
            }
            int length = this.indentLevel * this.indentSize;
            if (this.continuation) {
                length += this.continuationIndentSize;
            }
            switch (type) {
                case 175: {
                    if (!this.useTabs) {
                        String s = this.generateIndentString(length + string.length());
                        this.column += s.length();
                        this._out.write(s);
                        break;
                    }
                    if (!this.useLeadingTabs) {
                        String s = this.generateIndentString(length + string.length());
                        this.column += s.length();
                        s = StringHelper.replace(s, this.generateIndentString(this.indentSize), TAB);
                        this._out.write(s);
                        break;
                    }
                    String s = this.generateIndentString(length);
                    this.column += length;
                    s = StringHelper.replace(s, this.generateIndentString(this.indentSize), TAB);
                    this._out.write(s);
                    this.column += string.length();
                    this._out.write(string);
                    break;
                }
                default: {
                    String s = this.generateIndentString(length);
                    offset += length;
                    this.column += length + string.length();
                    if (this.useTabs) {
                        s = StringHelper.replace(s, this.generateIndentString(this.indentSize), TAB);
                    }
                    this._out.write(s);
                    this._out.write(string);
                    break;
                }
            }
            this.newline = false;
        } else {
            switch (type) {
                case 175: {
                    if (this.useTabs && !this.useLeadingTabs && string.length() > this.indentSize) {
                        int tabCount = this.column / this.indentSize;
                        int spacesCount = this.column - 1 - tabCount * this.indentSize;
                        this.column += string.length();
                        if (spacesCount == 0) {
                            string = StringHelper.replace(string, this.generateIndentString(this.indentSize), TAB);
                            this._out.write(string);
                            break;
                        }
                        if (spacesCount < 0) {
                            this._out.write(TAB);
                        }
                        this._out.write(TAB);
                        string = StringHelper.replace(string.substring(this.indentSize - spacesCount), this.generateIndentString(this.indentSize), TAB);
                        this._out.write(string);
                        break;
                    }
                }
                default: {
                    offset = this.column;
                    this.column += string.length();
                    this._out.write(string);
                }
            }
        }
        this.last = type;
        return offset;
    }

    public void printBlankLines(int amount) throws IOException {
        int i = 0;
        while (i < amount) {
            this.printNewline();
            ++i;
        }
    }

    public int printLeftBrace() throws IOException {
        return this.printLeftBrace(true, true);
    }

    public int printLeftBrace(boolean newlineBefore, boolean newlineAfter) throws IOException {
        return this.printLeftBrace(newlineBefore, newlineAfter, true);
    }

    public int printLeftBrace(boolean newlineBefore, boolean newlineAfter, boolean indent) throws IOException {
        if (newlineBefore) {
            this.printNewline();
        }
        if (indent && this.leftBraceIndent > 0) {
            this.print(this.generateIndentString(this.leftBraceIndent), 175);
        }
        int offset = this.print(LCURLY, 7);
        if (newlineAfter) {
            this.printNewline();
        }
        this.indent();
        return offset;
    }

    public void printNewline() throws IOException {
        this._out.write(this.lineSeparator);
        this.newline = true;
        this.column = 1;
        ++this.line;
    }

    public int printRightBrace() throws IOException {
        return this.printRightBrace(true);
    }

    public int printRightBrace(boolean newlineAfter) throws IOException {
        return this.printRightBrace(8, newlineAfter);
    }

    public int printRightBrace(int type, boolean newlineAfter) throws IOException {
        return this.printRightBrace(type, true, newlineAfter);
    }

    public int printRightBrace(int type, boolean whitespaceBefore, boolean newlineAfter) throws IOException {
        this.unindent();
        int offset = 1;
        offset = whitespaceBefore ? this.print(this.getRightBrace(), type) : this.print(RCURLY, type);
        if (newlineAfter && (this.indentLevel > 0 || this.insertTrailingEmpty && !this.footer)) {
            this.printNewline();
        }
        return offset;
    }

    public void unindent() {
        this.setIndentLevel(this.indentLevel - 1);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this._out.write(cbuf, off, len);
    }

    String getRightBrace() {
        if (this._rightBrace == null) {
            StringBuffer buf = new StringBuffer(this.getIndentSize() + 1);
            buf.append(this.generateIndentString(AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT, 0)));
            buf.append(RCURLY);
            this._rightBrace = buf.toString();
        }
        return this._rightBrace;
    }

    private String generateIndentString(int length) {
        if (length == 0) {
            return EMPTY_STRING;
        }
        if (length > this._indentChars.length) {
            int offset;
            char[] buf = new char[(int)(1.4 * (double)length)];
            int i = 0;
            while (true) {
                if ((offset = i * this._indentChars.length) + this._indentChars.length > buf.length) break;
                System.arraycopy(this._indentChars, 0, buf, offset, this._indentChars.length);
                ++i;
            }
            System.arraycopy(this._indentChars, 0, buf, offset, buf.length - offset);
            this._indentChars = buf;
        }
        return new String(this._indentChars, 0, length).intern();
    }
}

