/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.axis2.datasource.jaxb.JAXBDataSource;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.databinding.JAXBBlock;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.message.util.XMLStreamWriterWithOS;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBBlockImpl
extends BlockImpl
implements JAXBBlock {
    private static final Log log = LogFactory.getLog(JAXBBlockImpl.class);
    private static final boolean DEBUG_ENABLED = log.isDebugEnabled();

    JAXBBlockImpl(Object busObject, JAXBBlockContext busContext, QName qName, BlockFactory factory) throws JAXBException {
        super(busObject, (Object)busContext, qName, factory);
    }

    JAXBBlockImpl(OMElement omElement, JAXBBlockContext busContext, QName qName, BlockFactory factory) {
        super(omElement, (Object)busContext, qName, factory);
    }

    protected Object _getBOFromReader(XMLStreamReader reader, Object busContext) throws XMLStreamException, WebServiceException {
        JAXBBlockContext ctx = (JAXBBlockContext)busContext;
        try {
            this.busObject = ctx.unmarshal(reader);
        }
        catch (JAXBException je) {
            if (DEBUG_ENABLED) {
                try {
                    log.debug((Object)("JAXBContext for unmarshal failure:" + ctx.getJAXBContext(ctx.getClassLoader())));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)je);
        }
        return this.busObject;
    }

    protected Object _getBOFromOM(OMElement omElement, Object busContext) throws XMLStreamException, WebServiceException {
        if (omElement instanceof OMSourcedElement) {
            OMDataSource ds = ((OMSourcedElement)omElement).getDataSource();
            if (ds instanceof JAXBDataSource) {
                try {
                    JAXBDSContext dsContext = ((JAXBDataSource)ds).getContext();
                    busContext = new JAXBBlockContext(dsContext.getJAXBContext());
                }
                catch (JAXBException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                return ((JAXBDataSource)ds).getObject();
            }
            if (ds instanceof JAXBBlockImpl) {
                JAXBBlockContext blockContext = (JAXBBlockContext)((JAXBBlockImpl)ds).getBusinessContext();
                busContext = blockContext;
                return ((JAXBBlockImpl)ds).getObject();
            }
        }
        return super._getBOFromOM(omElement, busContext);
    }

    private byte[] _getBytesFromBO(Object busObj, Object busContext, String encoding) throws XMLStreamException, WebServiceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriterWithOS writer = new XMLStreamWriterWithOS(baos, encoding);
        this._outputFromBO(busObj, busContext, writer);
        writer.flush();
        writer.close();
        return baos.toByteArray();
    }

    protected XMLStreamReader _getReaderFromBO(Object busObj, Object busContext) throws XMLStreamException, WebServiceException {
        ByteArrayInputStream baos = new ByteArrayInputStream(this._getBytesFromBO(busObj, busContext, "utf-8"));
        return StAXUtils.createXMLStreamReader((InputStream)baos, (String)"utf-8");
    }

    protected void _outputFromBO(Object busObject, Object busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        JAXBBlockContext ctx = (JAXBBlockContext)busContext;
        try {
            ctx.marshal(busObject, writer);
        }
        catch (JAXBException je) {
            if (DEBUG_ENABLED) {
                try {
                    log.debug((Object)("JAXBContext for marshal failure:" + ctx.getJAXBContext(ctx.getClassLoader())));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)je);
        }
    }

    public boolean isElementData() {
        return true;
    }

    public void close() {
    }

    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        try {
            byte[] bytes = this._getBytesFromBO(this.getBusinessObject(false), this.busContext, encoding);
            return new ByteArrayInputStream(bytes);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Object getObject() {
        try {
            return this.getBusinessObject(false);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    public OMDataSourceExt copy() throws OMException {
        if (DEBUG_ENABLED) {
            log.debug((Object)"Making a copy of the JAXB object");
        }
        return new JAXBDataSource(this.getObject(), (JAXBDSContext)this.getBusinessContext());
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        try {
            return this._getBytesFromBO(this.getBusinessObject(false), this.busContext, encoding);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public void setParent(Message message) {
        if (this.busContext != null) {
            ((JAXBBlockContext)this.busContext).setMessage(message);
        }
        super.setParent(message);
    }
}

