/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.ApiSelector
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonOld

final def airPluginTool = new AirPluginTool(args[0], args[1])
final def props = airPluginTool.getStepProperties()

def changeRequestId = props['changeRequestId']
def status = props['status']

println "Checking request with number ${changeRequestId}"
println "Setting status to ${status}"
println ""

def newAPI = ApiSelector.selectApi(airPluginTool)

if (newAPI) {
    HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airPluginTool)
    helper.setStatus(status)
}
else {
    HelperRestClientJsonOld helperOld = new HelperRestClientJsonOld(airPluginTool)
    helperOld.setStatus(status)
}

println "Status set to ${status}!"
System.exit(0)
