/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class OMAttributeImpl
implements OMAttribute {
    private String localName;
    private String value;
    private OMNamespace namespace;
    private OMFactory factory;
    protected OMElement owner;

    public OMAttributeImpl(String localName, OMNamespace ns, String value, OMFactory factory) {
        if (localName == null || localName.trim().length() == 0) {
            throw new IllegalArgumentException("Local name may not be null or empty");
        }
        this.localName = localName;
        this.value = value;
        this.namespace = ns;
        this.factory = factory;
    }

    public QName getQName() {
        if (this.namespace != null) {
            if (this.namespace.getPrefix() == null) {
                return new QName(this.namespace.getNamespaceURI(), this.localName);
            }
            return new QName(this.namespace.getNamespaceURI(), this.localName, this.namespace.getPrefix());
        }
        return new QName(this.localName);
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        if (localName == null || localName.trim().length() == 0) {
            throw new IllegalArgumentException("Local name may not be null or empty");
        }
        this.localName = localName;
    }

    public String getAttributeValue() {
        return this.value;
    }

    public void setAttributeValue(String value) {
        this.value = value;
    }

    public void setOMNamespace(OMNamespace omNamespace) {
        this.namespace = omNamespace;
    }

    public OMNamespace getNamespace() {
        return this.namespace;
    }

    public OMFactory getOMFactory() {
        return this.factory;
    }

    public OMElement getOwner() {
        return this.owner;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OMAttribute)) {
            return false;
        }
        OMAttribute other = (OMAttribute)obj;
        return this.namespace == null ? other.getNamespace() == null : this.namespace.equals(other.getNamespace()) && this.localName.equals(other.getLocalName()) && (this.value == null ? other.getAttributeValue() == null : this.value.equals(other.getAttributeValue()));
    }

    public int hashCode() {
        return this.localName.hashCode() ^ (this.value != null ? this.value.hashCode() : 0) ^ (this.namespace != null ? this.namespace.hashCode() : 0);
    }
}

