/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.ws.Holder;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.ClassFinder;
import org.apache.axis2.jaxws.message.databinding.JAXBUtilsMonitor;
import org.apache.axis2.jaxws.message.factory.ClassFinderFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBUtils {
    private static final Log log = LogFactory.getLog(JAXBUtils.class);
    private static Map<ClassLoader, Map<String, JAXBContextValue>> jaxbMap = new ConcurrentHashMap<ClassLoader, Map<String, JAXBContextValue>>();
    private static Pool<JAXBContext, Marshaller> mpool = new Pool();
    private static Pool<JAXBContext, Unmarshaller> upool = new Pool();
    private static Pool<JAXBContext, JAXBIntrospector> ipool = new Pool();
    private static boolean ENABLE_MARSHALL_POOLING = false;
    private static boolean ENABLE_UNMARSHALL_POOLING = true;
    private static boolean ENABLE_INTROSPECTION_POOLING = false;
    private static int MAX_LOAD_FACTOR = 32;
    private static String[] commonArrayClasses = new String[]{"boolean[]", "byte[]", "char[][]", "double[]", "float[]", "int[]", "long[]", "short[]", "java.lang.String[]", "java.lang.Object[]", "java.awt.Image[]", "java.math.BigDecimal[]", "java.math.BigInteger[]", "java.util.Calendar[]", "javax.xml.namespace.QName[]"};

    public static JAXBContext getJAXBContext(TreeSet<String> contextPackages) throws JAXBException {
        return JAXBUtils.getJAXBContext(contextPackages, (Holder<CONSTRUCTION_TYPE>)new Holder(), contextPackages.toString(), null);
    }

    public static JAXBContext getJAXBContext(TreeSet<String> contextPackages, ClassLoader cacheKey) throws JAXBException {
        return JAXBUtils.getJAXBContext(contextPackages, (Holder<CONSTRUCTION_TYPE>)new Holder(), contextPackages.toString(), cacheKey);
    }

    public static JAXBContext getJAXBContext(TreeSet<String> contextPackages, Holder<CONSTRUCTION_TYPE> constructionType, String key) throws JAXBException {
        return JAXBUtils.getJAXBContext(contextPackages, constructionType, key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext getJAXBContext(TreeSet<String> contextPackages, Holder<CONSTRUCTION_TYPE> constructionType, String key, ClassLoader cacheKey) throws JAXBException {
        JAXBContextValue contextValue;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Following packages are in this batch of getJAXBContext() :");
            for (String pkg : contextPackages) {
                log.debug((Object)pkg);
            }
        }
        JAXBUtilsMonitor.addPackageKey(key);
        ClassLoader cl = JAXBUtils.getContextClassLoader();
        Map<String, JAXBContextValue> innerMap = null;
        innerMap = JAXBUtils.getInnerMap(cacheKey, cl);
        if (innerMap == null) {
            Map<ClassLoader, Map<String, JAXBContextValue>> map = jaxbMap;
            synchronized (map) {
                innerMap = JAXBUtils.getInnerMap(cacheKey, cl);
                if (innerMap == null) {
                    JAXBUtils.adjustPoolSize(jaxbMap);
                    innerMap = new ConcurrentHashMap<String, JAXBContextValue>();
                    if (cacheKey != null) {
                        jaxbMap.put(cacheKey, innerMap);
                    }
                }
            }
        }
        if (contextPackages == null) {
            contextPackages = new TreeSet();
        }
        if ((contextValue = innerMap.get(key)) == null) {
            Map<String, JAXBContextValue> map = innerMap;
            synchronized (map) {
                contextValue = innerMap.get(key);
                if (contextValue == null) {
                    JAXBUtils.adjustPoolSize(innerMap);
                    TreeSet<String> validContextPackages = new TreeSet<String>((SortedSet<String>)contextPackages);
                    contextValue = JAXBUtils.createJAXBContextValue(validContextPackages, cl);
                    if (cacheKey != null && validContextPackages.size() != contextPackages.size()) {
                        validContextPackages = new TreeSet<String>((SortedSet<String>)contextPackages);
                        contextValue = JAXBUtils.createJAXBContextValue(validContextPackages, cacheKey);
                    }
                    String validPackagesKey = validContextPackages.toString();
                    innerMap.put(key, contextValue);
                    innerMap.put(validPackagesKey, contextValue);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("JAXBContext [created] for " + key));
                        log.debug((Object)("JAXBContext also stored by the list of valid packages:" + validPackagesKey));
                    }
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("JAXBContext [from pool] for " + key));
        }
        constructionType.value = contextValue.constructionType;
        return contextValue.jaxbContext;
    }

    private static Map<String, JAXBContextValue> getInnerMap(ClassLoader cacheKey, ClassLoader cl) {
        Map<String, JAXBContextValue> innerMap;
        if (cacheKey != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using supplied classloader to retrieve JAXBContext: " + cacheKey));
            }
            innerMap = jaxbMap.get(cacheKey);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using classloader from Thread to retrieve JAXBContext: " + cl));
            }
            innerMap = jaxbMap.get(cl);
        }
        return innerMap;
    }

    private static JAXBContextValue createJAXBContextValue(TreeSet<String> contextPackages, ClassLoader cl) throws JAXBException {
        JAXBContext context;
        Map<String, JAXBContextValue> innerMap;
        JAXBContextValue contextValue = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Following packages are in this batch of getJAXBContext() :");
            for (String pkg : contextPackages) {
                log.debug((Object)pkg);
            }
            log.debug((Object)("This classloader will be used to construct the JAXBContext" + cl));
        }
        Iterator<String> it = contextPackages.iterator();
        while (it.hasNext()) {
            String p = it.next();
            if (p.startsWith("javax.xml.ws.wsaddressing") || !p.startsWith("java.") && !p.startsWith("javax.")) continue;
            it.remove();
        }
        it = contextPackages.iterator();
        boolean contextConstruction = true;
        boolean isJAXBFound = false;
        while (it.hasNext()) {
            String p = it.next();
            if (JAXBUtils.checkPackage(p, cl)) {
                isJAXBFound = true;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Package " + p + " contains an ObjectFactory or package-info class."));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Package " + p + " does not contain an ObjectFactory or package-info class.  Searching for JAXB classes"));
            }
            List<Class> classes = null;
            classes = JAXBUtils.getAllClassesFromPackage(p, cl);
            if (classes == null || classes.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Package " + p + " does not have any JAXB classes.  It is removed from the JAXB context path."));
                }
                it.remove();
                continue;
            }
            contextConstruction = false;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Package " + p + " does not contain ObjectFactory, but it does contain other JAXB classes."));
        }
        if (!isJAXBFound && log.isDebugEnabled()) {
            log.debug((Object)"Both ObjectFactory & package-info not found in package hierachy");
        }
        if ((innerMap = jaxbMap.get(cl)) != null && (contextValue = innerMap.get(contextPackages.toString())) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully found JAXBContext with updated context list:" + contextValue.jaxbContext.toString()));
            }
            return contextValue;
        }
        if (contextConstruction && (context = JAXBUtils.createJAXBContextUsingContextPath(contextPackages, cl)) != null) {
            contextValue = new JAXBContextValue(context, CONSTRUCTION_TYPE.BY_CONTEXT_PATH);
        }
        if (contextValue == null) {
            it = contextPackages.iterator();
            ArrayList<Class> fullList = new ArrayList<Class>();
            while (it.hasNext()) {
                String pkg = it.next();
                fullList.addAll(JAXBUtils.getAllClassesFromPackage(pkg, cl));
            }
            JAXBUtils.addCommonArrayClasses(fullList);
            Class[] classArray = fullList.toArray(new Class[0]);
            JAXBContext context2 = JAXBUtils.JAXBContext_newInstance(classArray, cl);
            if (context2 != null) {
                contextValue = new JAXBContextValue(context2, CONSTRUCTION_TYPE.BY_CLASS_ARRAY);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully created JAXBContext " + contextValue.jaxbContext.toString()));
        }
        return contextValue;
    }

    public static Unmarshaller getJAXBUnmarshaller(JAXBContext context) throws JAXBException {
        if (!ENABLE_UNMARSHALL_POOLING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unmarshaller created [no pooling]");
            }
            return context.createUnmarshaller();
        }
        Unmarshaller unm = upool.get(context);
        if (unm == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unmarshaller created [not in pool]");
            }
            unm = context.createUnmarshaller();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Unmarshaller obtained [from  pool]");
        }
        return unm;
    }

    public static void releaseJAXBUnmarshaller(JAXBContext context, Unmarshaller unmarshaller) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unmarshaller placed back into pool");
        }
        if (ENABLE_UNMARSHALL_POOLING) {
            unmarshaller.setAttachmentUnmarshaller(null);
            upool.put(context, unmarshaller);
        }
    }

    public static Marshaller getJAXBMarshaller(JAXBContext context) throws JAXBException {
        Marshaller m = null;
        if (!ENABLE_MARSHALL_POOLING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marshaller created [no pooling]");
            }
            m = context.createMarshaller();
        } else {
            m = mpool.get(context);
            if (m == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Marshaller created [not in pool]");
                }
                m = context.createMarshaller();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Marshaller obtained [from  pool]");
            }
        }
        m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return m;
    }

    public static void releaseJAXBMarshaller(JAXBContext context, Marshaller marshaller) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Marshaller placed back into pool");
        }
        if (ENABLE_MARSHALL_POOLING) {
            marshaller.setAttachmentMarshaller(null);
            mpool.put(context, marshaller);
        }
    }

    public static JAXBIntrospector getJAXBIntrospector(JAXBContext context) throws JAXBException {
        JAXBIntrospector i = null;
        if (!ENABLE_INTROSPECTION_POOLING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"JAXBIntrospector created [no pooling]");
            }
            i = context.createJAXBIntrospector();
        } else {
            i = ipool.get(context);
            if (i == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"JAXBIntrospector created [not in pool]");
                }
                i = context.createJAXBIntrospector();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"JAXBIntrospector obtained [from  pool]");
            }
        }
        return i;
    }

    public static void releaseJAXBIntrospector(JAXBContext context, JAXBIntrospector introspector) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"JAXBIntrospector placed back into pool");
        }
        if (ENABLE_INTROSPECTION_POOLING) {
            ipool.put(context, introspector);
        }
    }

    private static boolean checkPackage(String p, ClassLoader cl) {
        block8: {
            Class cls;
            block7: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("checking package :" + p));
                }
                try {
                    cls = JAXBUtils.forName(p + ".ObjectFactory", false, cl);
                    if (cls != null) {
                        return true;
                    }
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)("ObjectFactory Class Not Found " + e));
                    log.debug((Object)("...caused by " + e.getCause() + " " + JavaUtils.stackToString(e)));
                }
            }
            try {
                cls = JAXBUtils.forName(p + ".package-info", false, cl);
                if (cls != null) {
                    return true;
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)("package-info Class Not Found " + e));
                log.debug((Object)("...caused by " + e.getCause() + " " + JavaUtils.stackToString(e)));
            }
        }
        return false;
    }

    private static JAXBContext createJAXBContextUsingContextPath(TreeSet<String> packages, ClassLoader cl) {
        JAXBContext context;
        block6: {
            context = null;
            String contextpath = "";
            for (String p : packages) {
                if (contextpath.length() != 0) {
                    contextpath = contextpath + ":";
                }
                contextpath = contextpath + p;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to create JAXBContext with contextPath=" + contextpath));
                }
                context = JAXBUtils.JAXBContext_newInstance(contextpath, cl);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Successfully created JAXBContext:" + context));
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)"  Unsuccessful: We will now use an alterative JAXBConstruct construction");
                log.debug((Object)("  Reason " + e.toString()));
            }
        }
        return context;
    }

    private static List<Class> getAllClassesFromPackage(String pkg, ClassLoader cl) {
        ArrayList<Class> classes;
        block7: {
            block6: {
                if (pkg == null) {
                    return new ArrayList<Class>();
                }
                classes = new ArrayList<Class>();
                try {
                    ArrayList<Class> classesFromDir = JAXBUtils.getClassesFromDirectory(pkg, cl);
                    JAXBUtils.checkClasses(classesFromDir, pkg);
                    classes.addAll(classesFromDir);
                }
                catch (ClassNotFoundException e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)"getClassesFromDirectory failed to get Classes");
                }
            }
            try {
                if (classes.size() <= 0) {
                    ClassFinderFactory cff = (ClassFinderFactory)FactoryRegistry.getFactory(ClassFinderFactory.class);
                    ClassFinder cf = cff.getClassFinder();
                    ArrayList<Class> classesFromJar = cf.getClassesFromJarFile(pkg, cl);
                    JAXBUtils.checkClasses(classesFromJar, pkg);
                    classes.addAll(classesFromJar);
                }
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)"getClassesFromJarFile failed to get Classes");
            }
        }
        return classes;
    }

    private static void checkClasses(List<Class> list, String pkg) {
        int i = 0;
        while (i < list.size()) {
            Class cls = list.get(i);
            if (!cls.isInterface() && ClassUtils.getDefaultPublicConstructor(cls) != null && !ClassUtils.isJAXWSClass(cls) && cls.getPackage().getName().equals(pkg)) {
                ++i;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing class " + cls + " from consideration because it is not in package " + pkg + " or is an interface or does not have a public constructor or is" + " a jaxws class"));
            }
            list.remove(i);
        }
    }

    private static ArrayList<Class> getClassesFromDirectory(String pkg, ClassLoader cl) throws ClassNotFoundException {
        String pckgname = pkg;
        ArrayList<File> directories = new ArrayList<File>();
        try {
            String path = pckgname.replace('.', '/');
            Enumeration<URL> resources = cl.getResources(path);
            while (resources.hasMoreElements()) {
                directories.add(new File(URLDecoder.decode(resources.nextElement().getPath(), "UTF-8")));
            }
        }
        catch (UnsupportedEncodingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(pckgname + " does not appear to be a valid package (Unsupported encoding)"));
            }
            throw new ClassNotFoundException(Messages.getMessage((String)"ClassUtilsErr2", (String)pckgname));
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IOException was thrown when trying to get all resources for " + pckgname));
            }
            throw new ClassNotFoundException(Messages.getMessage((String)"ClassUtilsErr3", (String)pckgname));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : directories) {
            String[] files;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Adding JAXB classes from directory: " + directory.getName()));
            }
            if (!directory.exists()) continue;
            for (String file : files = directory.list()) {
                if (!file.endsWith(".class")) continue;
                String className = pckgname + '.' + file.substring(0, file.length() - 6);
                try {
                    Class clazz = JAXBUtils.forName(className, false, JAXBUtils.getContextClassLoader());
                    if (clazz.isInterface() || !clazz.isEnum() && ClassUtils.getDefaultPublicConstructor(clazz) == null || ClassUtils.isJAXWSClass(clazz) || Exception.class.isAssignableFrom(clazz)) continue;
                    clazz.getDeclaredMethods();
                    clazz.getDeclaredFields();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding class: " + file));
                    }
                    classes.add(clazz);
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Tried to load class " + className + " while constructing a JAXBContext.  This class will be skipped.  Processing Continues."));
                    log.debug((Object)("  The reason that class could not be loaded:" + e.toString()));
                    log.debug((Object)JavaUtils.stackToString(e));
                }
            }
        }
        return classes;
    }

    private static void addCommonArrayClasses(List<Class> list) {
        ClassLoader cl = JAXBUtils.getContextClassLoader();
        for (int i = 0; i < commonArrayClasses.length; ++i) {
            String className = commonArrayClasses[i];
            try {
                Class cls = JAXBUtils.forName(ClassUtils.getLoadableClassName(className), false, cl);
                list.add(cls);
                continue;
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Tried to load class " + className + " while constructing a JAXBContext.  This class will be skipped.  Processing Continues."));
                log.debug((Object)("  The reason that class could not be loaded:" + e.toString()));
                log.debug((Object)JavaUtils.stackToString(e));
            }
        }
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    if (cls == null) {
                        cls = Class.forName(className, initialize, classloader);
                    }
                    return cls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static JAXBContext JAXBContext_newInstance(final String context, final ClassLoader classloader) throws Exception {
        JAXBContext jaxbContext = null;
        try {
            if (log.isDebugEnabled()) {
                if (context == null || context.length() == 0) {
                    log.debug((Object)"JAXBContext is constructed without a context String.");
                } else {
                    log.debug((Object)("JAXBContext is constructed with a context of:" + context));
                }
            }
            jaxbContext = (JAXBContext)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws JAXBException {
                    return JAXBContext.newInstance((String)context, (ClassLoader)classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw e.getException();
        }
        return jaxbContext;
    }

    private static JAXBContext JAXBContext_newInstance(final Class[] classArray, final ClassLoader cl) throws JAXBException {
        JAXBContext jaxbContext;
        block7: {
            jaxbContext = null;
            try {
                if (log.isDebugEnabled()) {
                    if (classArray == null || classArray.length == 0) {
                        log.debug((Object)"JAXBContext is constructed with 0 input classes.");
                    } else {
                        log.debug((Object)("JAXBContext is constructed with " + classArray.length + " input classes."));
                    }
                }
                jaxbContext = (JAXBContext)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws JAXBException {
                        Thread currentThread = Thread.currentThread();
                        ClassLoader savedClassLoader = currentThread.getContextClassLoader();
                        try {
                            currentThread.setContextClassLoader(cl);
                            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classArray);
                            return jAXBContext;
                        }
                        finally {
                            currentThread.setContextClassLoader(savedClassLoader);
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exception thrown from AccessController: " + e));
                    log.debug((Object)("  Exception is " + e.getException()));
                }
                if (e.getException() instanceof JAXBException) {
                    throw (JAXBException)e.getException();
                }
                if (!(e.getException() instanceof RuntimeException)) break block7;
                throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
            }
        }
        return jaxbContext;
    }

    private static void adjustPoolSize(Map map) {
        if (map.size() > MAX_LOAD_FACTOR) {
            Iterator it = map.entrySet().iterator();
            boolean removeIt = false;
            while (it.hasNext()) {
                it.next();
                if (removeIt) {
                    it.remove();
                }
                removeIt = !removeIt;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pool<K, V> {
        private Map<K, List<V>> map = new ConcurrentHashMap<K, List<V>>();
        private static int MAX_LIST_FACTOR = 10;

        private Pool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) {
            List<V> values;
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() > 0) {
                    return values.remove(values.size() - 1);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            List<V> values;
            this.adjustSize();
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() < MAX_LIST_FACTOR) {
                    values.add(value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<V> getValues(K key) {
            List<V> values = this.map.get(key);
            if (values != null) {
                return values;
            }
            Pool pool = this;
            synchronized (pool) {
                values = this.map.get(key);
                if (values == null) {
                    values = new ArrayList<V>();
                    this.map.put(key, values);
                }
                return values;
            }
        }

        private void adjustSize() {
            if (this.map.size() > MAX_LOAD_FACTOR) {
                Iterator<Map.Entry<K, List<V>>> it = this.map.entrySet().iterator();
                boolean removeIt = false;
                while (it.hasNext()) {
                    it.next();
                    if (removeIt) {
                        it.remove();
                    }
                    removeIt = !removeIt;
                }
            }
        }
    }

    static class JAXBContextValue {
        public JAXBContext jaxbContext;
        public CONSTRUCTION_TYPE constructionType;

        public JAXBContextValue(JAXBContext jaxbContext, CONSTRUCTION_TYPE constructionType) {
            this.jaxbContext = jaxbContext;
            this.constructionType = constructionType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CONSTRUCTION_TYPE {
        BY_CLASS_ARRAY,
        BY_CONTEXT_PATH,
        UNKNOWN;

    }
}

