/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;

public class MetaDataEntry
implements Externalizable,
SafeSerializable {
    private static final long serialVersionUID = 8978361069526299875L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    private String className = null;
    private String qnameAsString = null;
    private String extraName = null;
    private ArrayList children = null;
    public static String END_OF_LIST = "LAST_ENTRY";
    private static final String UNSUPPORTED_SUID = "Serialization version ID is not supported.";
    private static final String UNSUPPORTED_REVID = "Revision ID is not supported.";

    public MetaDataEntry() {
    }

    public MetaDataEntry(String className, String qnameAsString) {
        this.className = className;
        this.qnameAsString = qnameAsString;
    }

    public MetaDataEntry(String className, String qnameAsString, String extraName) {
        this.className = className;
        this.qnameAsString = qnameAsString;
        this.extraName = extraName;
    }

    public MetaDataEntry(String className, String qnameAsString, ArrayList children) {
        this.className = className;
        this.qnameAsString = qnameAsString;
        this.children = children;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String c) {
        this.className = c;
    }

    public QName getQName() {
        if (this.qnameAsString != null) {
            return QName.valueOf(this.qnameAsString);
        }
        return null;
    }

    public void setQName(QName q) {
        this.qnameAsString = q != null ? q.toString() : null;
    }

    public void setQName(String n) {
        this.qnameAsString = n;
    }

    public String getQNameAsString() {
        return this.qnameAsString;
    }

    public String getName() {
        return this.qnameAsString;
    }

    public String getExtraName() {
        return this.extraName;
    }

    public void setExtraName(String e) {
        this.extraName = e;
    }

    public boolean isListEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList L) {
        this.children = L;
    }

    public void addToList(MetaDataEntry e) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(e);
    }

    public void removeList() {
        this.children = null;
    }

    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeLong(8978361069526299875L);
        out.writeInt(2);
        out.writeObject(this.className);
        out.writeObject(this.qnameAsString);
        out.writeObject(this.extraName);
        out.writeList(this.children);
    }

    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != 8978361069526299875L) {
            throw new ClassNotFoundException(UNSUPPORTED_SUID);
        }
        if (revID != 2) {
            throw new ClassNotFoundException(UNSUPPORTED_REVID);
        }
        this.className = (String)in.readObject();
        this.qnameAsString = (String)in.readObject();
        this.extraName = (String)in.readObject();
        this.children = in.readArrayList();
    }
}

