/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.apache.axis2.util.MultipleEntryHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XFormURLEncodedBuilder
implements Builder {
    private static final Log log = LogFactory.getLog((Class)XFormURLEncodedBuilder.class);

    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        SOAPFactory soapFactory;
        AxisEndpoint axisEndpoint;
        MultipleEntryHashMap parameterMap = new MultipleEntryHashMap();
        AxisBindingOperation axisBindingOperation = (AxisBindingOperation)messageContext.getProperty("AxisBindingOperation");
        String queryParameterSeparator = null;
        String templatedPath = null;
        if (axisBindingOperation != null) {
            queryParameterSeparator = (String)axisBindingOperation.getProperty("whttp:queryParameterSeparator");
            templatedPath = (String)axisBindingOperation.getProperty("whttp:location");
        }
        if (queryParameterSeparator == null) {
            queryParameterSeparator = "&";
        }
        if ((axisEndpoint = (AxisEndpoint)messageContext.getProperty("endpoint")) != null) {
            AxisBinding axisBinding = axisEndpoint.getBinding();
            String soapVersion = (String)axisBinding.getProperty("wsoap:version");
            soapFactory = this.getSOAPFactory(soapVersion);
        } else {
            soapFactory = this.getSOAPFactory("http://www.w3.org/2003/05/soap-envelope");
        }
        EndpointReference endpointReference = messageContext.getTo();
        if (endpointReference == null) {
            throw new AxisFault("Cannot create DocumentElement without destination EPR");
        }
        String requestURL = endpointReference.getAddress();
        try {
            requestURL = this.extractParametersUsingHttpLocation(templatedPath, parameterMap, requestURL, queryParameterSeparator);
        }
        catch (UnsupportedEncodingException e) {
            throw AxisFault.makeFault(e);
        }
        String query = requestURL;
        int index = requestURL.indexOf("?");
        if (index > -1) {
            query = requestURL.substring(index + 1);
        }
        this.extractParametersFromRequest(parameterMap, query, queryParameterSeparator, (String)messageContext.getProperty("CHARACTER_SET_ENCODING"), inputStream);
        return BuilderUtil.buildsoapMessage(messageContext, parameterMap, soapFactory);
    }

    protected void extractParametersFromRequest(MultipleEntryHashMap parameterMap, String query, String queryParamSeparator, final String charsetEncoding, final InputStream inputStream) throws AxisFault {
        if (query != null && !"".equals(query)) {
            String[] parts = query.split(queryParamSeparator);
            for (int i = 0; i < parts.length; ++i) {
                int separator = parts[i].indexOf("=");
                if (separator <= 0) continue;
                String value = parts[i].substring(separator + 1);
                try {
                    value = URIEncoderDecoder.decode(value);
                }
                catch (UnsupportedEncodingException e) {
                    throw AxisFault.makeFault(e);
                }
                parameterMap.put(parts[i].substring(0, separator), value);
            }
        }
        if (inputStream != null) {
            try {
                String line;
                InputStreamReader inputStreamReader = null;
                try {
                    inputStreamReader = (InputStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws UnsupportedEncodingException {
                            return new InputStreamReader(inputStream, charsetEncoding);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (UnsupportedEncodingException)e.getException();
                }
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((line = bufferedReader.readLine()) != null) {
                    String[] parts = line.split("&");
                    for (int i = 0; i < parts.length; ++i) {
                        int separator = parts[i].indexOf("=");
                        String value = parts[i].substring(separator + 1);
                        parameterMap.put(parts[i].substring(0, separator), URIEncoderDecoder.decode(value));
                    }
                }
            }
            catch (IOException e) {
                throw AxisFault.makeFault(e);
            }
        }
    }

    protected String extractParametersUsingHttpLocation(String templatedPath, MultipleEntryHashMap parameterMap, String requestURL, String queryParameterSeparator) throws AxisFault, UnsupportedEncodingException {
        if (templatedPath != null && !"".equals(templatedPath) && templatedPath.indexOf("{") > -1) {
            StringBuffer pathTemplate = new StringBuffer(templatedPath);
            int startIndex = 0;
            int templateStartIndex = 0;
            int templateEndIndex = 0;
            int indexOfNextConstant = 0;
            StringBuffer requestURIBuffer = new StringBuffer(requestURL);
            while (startIndex < requestURIBuffer.length()) {
                if ((templateStartIndex = pathTemplate.indexOf("{", templateStartIndex)) <= 0) continue;
                String constantPart = pathTemplate.substring(templateEndIndex + 1, templateStartIndex);
                constantPart = constantPart.replaceAll("\\{\\{", "{");
                constantPart = constantPart.replaceAll("}}", "}");
                templateEndIndex = pathTemplate.indexOf("}", templateStartIndex);
                if (pathTemplate.length() - 1 > templateEndIndex && pathTemplate.charAt(templateEndIndex + 1) == '}') {
                    templateEndIndex = pathTemplate.indexOf("}", templateEndIndex + 2);
                }
                String parameterName = pathTemplate.substring(templateStartIndex + 1, templateEndIndex);
                templateStartIndex = pathTemplate.indexOf("{", templateEndIndex);
                if (pathTemplate.charAt(templateStartIndex + 1) == '{') {
                    templateStartIndex = pathTemplate.indexOf("{", templateStartIndex + 2);
                }
                int endIndexOfConstant = requestURIBuffer.indexOf(constantPart, indexOfNextConstant) + constantPart.length();
                if (templateStartIndex == -1) {
                    if (templateEndIndex == pathTemplate.length() - 1) {
                        indexOfNextConstant = requestURIBuffer.indexOf("?", endIndexOfConstant);
                        if (indexOfNextConstant == -1) {
                            indexOfNextConstant = requestURIBuffer.indexOf(queryParameterSeparator, endIndexOfConstant);
                        }
                        if (indexOfNextConstant > 0) {
                            this.addParameterToMap(parameterMap, parameterName, requestURIBuffer.substring(endIndexOfConstant, indexOfNextConstant));
                            return requestURL.substring(indexOfNextConstant);
                        }
                        this.addParameterToMap(parameterMap, parameterName, requestURIBuffer.substring(endIndexOfConstant));
                        return "";
                    }
                    constantPart = pathTemplate.substring(templateEndIndex + 1, pathTemplate.length());
                    constantPart = constantPart.replaceAll("\\{\\{", "{");
                    constantPart = constantPart.replaceAll("}}", "}");
                    indexOfNextConstant = requestURIBuffer.indexOf(constantPart, endIndexOfConstant);
                    this.addParameterToMap(parameterMap, parameterName, requestURIBuffer.substring(endIndexOfConstant, indexOfNextConstant));
                    if (requestURIBuffer.length() > indexOfNextConstant + 1) {
                        return requestURIBuffer.substring(indexOfNextConstant + 1);
                    }
                    return "";
                }
                constantPart = pathTemplate.substring(templateEndIndex + 1, templateStartIndex);
                constantPart = constantPart.replaceAll("\\{\\{", "{");
                constantPart = constantPart.replaceAll("}}", "}");
                indexOfNextConstant = requestURIBuffer.indexOf(constantPart, endIndexOfConstant);
                this.addParameterToMap(parameterMap, parameterName, requestURIBuffer.substring(endIndexOfConstant, indexOfNextConstant));
                startIndex = indexOfNextConstant;
            }
        }
        return requestURL;
    }

    private void addParameterToMap(MultipleEntryHashMap parameterMap, String paramName, String paramValue) throws UnsupportedEncodingException, AxisFault {
        try {
            paramValue = URIEncoderDecoder.decode(paramValue);
        }
        catch (UnsupportedEncodingException e) {
            throw AxisFault.makeFault(e);
        }
        if (paramName.startsWith("!")) {
            parameterMap.put(paramName.substring(1), paramValue);
        } else {
            parameterMap.put(paramName, paramValue);
        }
    }

    private SOAPFactory getSOAPFactory(String nsURI) throws AxisFault {
        if (nsURI == null) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage("invalidSOAPversion"));
    }
}

