/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.xml.relax.swift;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.swiftinc.relax.schema.Grammar;
import jp.co.swiftinc.relax.schema.SchemaLoader;
import jp.co.swiftinc.relax.schema.SchemaSyntaxErrorException;
import jp.gr.xml.relax.sax.RELAXEntityResolver;
import jp.gr.xml.relax.swift.SwiftSchema;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierException;
import org.iso_relax.verifier.VerifierFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SwiftVerifierFactory
extends VerifierFactory {
    public Schema compileSchema(InputSource inputSource) throws VerifierConfigurationException, SAXException {
        return new SwiftSchema(this.loadSchema(inputSource));
    }

    private DocumentBuilder _getDocumentBuilder() throws VerifierConfigurationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new RELAXEntityResolver());
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new VerifierConfigurationException(parserConfigurationException);
        }
    }

    private Grammar loadSchema(InputSource inputSource) throws VerifierConfigurationException, SAXException {
        try {
            DocumentBuilder documentBuilder = this._getDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return SchemaLoader.load((Document)document, (String)inputSource.getSystemId());
        }
        catch (SchemaSyntaxErrorException schemaSyntaxErrorException) {
            throw new VerifierException((Exception)((Object)schemaSyntaxErrorException));
        }
        catch (SAXException sAXException) {
            throw new VerifierException(sAXException);
        }
        catch (IOException iOException) {
            throw new VerifierException(iOException);
        }
    }
}

