/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.axis2.transport.http.server.AxisHttpConnectionImpl;
import org.apache.axis2.transport.http.server.ConnectionListenerFailureHandler;
import org.apache.axis2.transport.http.server.HttpConnectionManager;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.params.HttpParams;

public class DefaultConnectionListener
implements IOProcessor {
    private static Log LOG = LogFactory.getLog((Class)DefaultConnectionListener.class);
    private volatile boolean destroyed = false;
    private final int port;
    private final HttpConnectionManager connmanager;
    private final ConnectionListenerFailureHandler failureHandler;
    private final HttpParams params;
    private ServerSocket serversocket = null;

    public DefaultConnectionListener(int port, HttpConnectionManager connmanager, ConnectionListenerFailureHandler failureHandler, HttpParams params) throws IOException {
        if (connmanager == null) {
            throw new IllegalArgumentException("Connection manager may not be null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("Failure handler may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.port = port;
        this.connmanager = connmanager;
        this.failureHandler = failureHandler;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!Thread.interrupted()) {
                try {
                    if (this.serversocket == null || this.serversocket.isClosed()) {
                        this.serversocket = new ServerSocket(this.port);
                        this.serversocket.setReuseAddress(true);
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("Listening on port " + this.serversocket.getLocalPort()));
                        }
                    }
                    LOG.debug((Object)"Waiting for incoming HTTP connection");
                    Socket socket = this.serversocket.accept();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Incoming HTTP connection from " + socket.getRemoteSocketAddress()));
                    }
                    AxisHttpConnectionImpl conn = new AxisHttpConnectionImpl(socket, this.params);
                    this.connmanager.process(conn);
                }
                catch (Throwable ex) {
                    if (Thread.interrupted()) {
                    } else if (this.failureHandler.failed(this, ex)) continue;
                    break;
                }
            }
        }
        finally {
            this.destroy();
        }
    }

    public void close() throws IOException {
        if (this.serversocket != null) {
            this.serversocket.close();
        }
    }

    public void destroy() {
        block2: {
            this.destroyed = true;
            try {
                this.close();
            }
            catch (IOException ex) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)"I/O error closing listener", (Throwable)ex);
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }
}

