/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.i18n.Messages;

public class ModuleConfiguration
implements ParameterInclude {
    private String moduleName;
    private ParameterInclude parameterInclude;
    private ParameterInclude parent;

    public ModuleConfiguration(String moduleName, ParameterInclude parent) {
        this.moduleName = moduleName;
        this.parent = parent;
        this.parameterInclude = new ParameterIncludeImpl();
    }

    public void addParameter(Parameter param) throws AxisFault {
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameterInclude.addParameter(param);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameterInclude.removeParameter(param);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameterInclude.deserializeParameters(parameterElement);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Parameter getParameter(String name) {
        return this.parameterInclude.getParameter(name);
    }

    public ArrayList getParameters() {
        return this.parameterInclude.getParameters();
    }

    public boolean isParameterLocked(String parameterName) {
        boolean loscked = false;
        if (this.parent != null) {
            loscked = this.parent.isParameterLocked(parameterName);
        }
        if (loscked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }
}

