/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing.syntax;

import de.hunsicker.jalopy.swing.syntax.SyntaxDocument;
import de.hunsicker.jalopy.swing.syntax.Token;
import de.hunsicker.jalopy.swing.syntax.TokenMarker;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public final class SyntaxView
extends PlainView {
    static final short TAG_WIDTH = 10;
    static final int BREAKPOINT_OFFSET = 12;
    FontMetrics lineNumberMetrics;
    private Font defaultFont;
    private Font lineNumberFont;
    private Font smallLineNumberFont;
    private Segment line = new Segment();
    private boolean initialised = false;

    public SyntaxView(Element elem) {
        super(elem);
    }

    public void drawLine(int lineIndex, Graphics g, int x, int y) {
        block4: {
            if (!this.initialised) {
                this.initialise(g);
            }
            SyntaxDocument document = (SyntaxDocument)this.getDocument();
            TokenMarker tokenMarker = document.getTokenMarker();
            Color def = this.getDefaultColor();
            try {
                Element lineElement = this.getElement().getElement(lineIndex);
                int start = lineElement.getStartOffset();
                int end = lineElement.getEndOffset();
                document.getText(start, end - (start + 1), this.line);
                g.setColor(def);
                this.drawLineNumber(g, lineIndex + 1, x, y);
                if (tokenMarker == null) {
                    Utilities.drawTabbedText(this.line, x + 12, y, g, (TabExpander)this, 0);
                    break block4;
                }
                this.paintSyntaxLine(this.line, lineIndex, x + 12, y, g, document, tokenMarker, def);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
        }
    }

    public Rectangle lineToRect(Shape a, int aline) {
        Rectangle r = null;
        if (this.metrics != null) {
            Rectangle alloc = a.getBounds();
            r = new Rectangle(alloc.x, alloc.y + aline * this.metrics.getHeight(), alloc.width, this.metrics.getHeight());
        }
        return r;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Document doc = this.getDocument();
        Element map = this.getElement();
        int lineIndex = map.getElementIndex(pos);
        Rectangle lineArea = this.lineToRect(a, lineIndex);
        int tabBase = lineArea.x + 10 + 2;
        Element eLine = map.getElement(lineIndex);
        int p0 = eLine.getStartOffset();
        Segment buffer = this.getLineBuffer();
        doc.getText(p0, pos - p0, buffer);
        int xOffs = Utilities.getTabbedTextWidth(buffer, this.metrics, tabBase, (TabExpander)this, p0);
        lineArea.x += xOffs + 12;
        lineArea.width = 1;
        lineArea.height = this.metrics.getHeight();
        return lineArea;
    }

    public float nextTabStop(float x, int tabOffset) {
        int tabSize = this.getTabSize() * this.metrics.charWidth('m');
        if (tabSize == 0) {
            return x;
        }
        int tabStopNumber = (int)((x - 12.0f) / (float)tabSize) + 1;
        return tabStopNumber * tabSize + 12 + 2;
    }

    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a.getBounds();
        Document doc = this.getDocument();
        int x = (int)fx;
        int y = (int)fy;
        if (y < alloc.y) {
            return this.getStartOffset();
        }
        if (y > alloc.y + alloc.height) {
            return this.getEndOffset() - 1;
        }
        Element map = doc.getDefaultRootElement();
        int lineIndex = Math.abs((y - alloc.y) / this.metrics.getHeight());
        if (lineIndex >= map.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element eLine = map.getElement(lineIndex);
        if (x < alloc.x) {
            return eLine.getStartOffset();
        }
        if (x > alloc.x + alloc.width) {
            return eLine.getEndOffset() - 1;
        }
        try {
            Segment buffer = this.getLineBuffer();
            int p0 = eLine.getStartOffset();
            int p1 = eLine.getEndOffset() - 1;
            doc.getText(p0, p1 - p0, buffer);
            int tabBase = alloc.x + 10 + 2;
            int offs = p0 + Utilities.getTabbedTextOffset(buffer, this.metrics, tabBase, x, this, p0);
            return offs;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    protected Color getDefaultColor() {
        return this.getContainer().getForeground();
    }

    private void drawLineNumber(Graphics g, int lineNumber, int x, int y) {
        String number = Integer.toString(lineNumber);
        int stringWidth = this.lineNumberMetrics.stringWidth(number);
        int xoffset = 12 - stringWidth - 4;
        if (xoffset < -2) {
            ++xoffset;
        }
        if (xoffset < -2) {
            g.setFont(this.smallLineNumberFont);
            g.drawString(number, x - 3, y);
        } else {
            g.setFont(this.lineNumberFont);
            g.drawString(number, x + xoffset, y);
        }
        g.setFont(this.defaultFont);
    }

    private void initialise(Graphics g) {
        this.defaultFont = g.getFont();
        this.lineNumberFont = this.defaultFont.deriveFont(9.0f);
        this.smallLineNumberFont = this.defaultFont.deriveFont(7.0f);
        Container c = this.getContainer();
        this.lineNumberMetrics = c.getFontMetrics(this.lineNumberFont);
        this.initialised = true;
    }

    private void paintSyntaxLine(Segment line, int lineIndex, int x, int y, Graphics g, SyntaxDocument document, TokenMarker tokenMarker, Color def) {
        byte id;
        Color[] colors = document.getColors();
        Token tokens = tokenMarker.markTokens(line, lineIndex);
        int offset = 0;
        while ((id = tokens.id) != 127) {
            int length = tokens.length;
            Color color = id == 0 ? def : colors[id];
            g.setColor(color == null ? def : color);
            line.count = length;
            x = Utilities.drawTabbedText(line, x, y, g, (TabExpander)this, offset);
            line.offset += length;
            offset += length;
            tokens = tokens.next;
        }
    }
}

