/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.wsdl.i18n.CodegenMessages;

public class ConfigPropertyFileLoader {
    private static Map dbSupporterTemplateNameMap;
    private static String testObjectTemplateName;
    private static String srcFolderName;
    private static String resourceFolderName;
    private static String[] extensionClassNames;
    private static String[] postExtensionClassNames;
    private static String[] thirdPartySchemaNames;
    private static String[] languageTypes;
    private static String[] databindingFrameworkNames;
    private static String[] unwrapSuppoerteddatabindingFrameworkNames;
    private static String[] unwrapDirectdatabindingFrameworkNames;
    private static Map languageEmitterMap;
    private static Map languageSpecificPropertiesMap;
    private static Map databindingFrameworkNameToExtensionMap;
    private static String defaultLanguage;
    private static String defaultDBFrameworkName;
    private static final String CODE_GEN_KEY_PREFIX = "codegen.extension";
    private static final String POST_CODE_GEN_KEY_PREFIX = "post.codegen.extension";
    private static final String THIRD_PARTY_SCHEMA_KEY_PREFIX = "codegen.thirdparty.schema";
    private static final String LANGUAGE_TYPE_KEY_PREFIX = "codegen.languages";
    private static final String DEFAULT_LANGUAGE_TYPE_KEY = "codegen.languages.default";
    private static final String EMITTER_CLASS_KEY = "codegen.emitters";
    private static final String DATA_BINDING_FRAMEWORK_NAME_KEY = "codegen.databinding.frameworks";
    private static final String DATA_BINDING_UNWRAP_SUPPORTED_FRAMEWORK_NAME_KEY = "codegen.databinding.unwrap.supported";
    private static final String DATA_BINDING_UNWRAP_DIRECT_FRAMEWORK_NAME_KEY = "codegen.databinding.unwrap.direct";
    private static final String DATA_BINDING_FRAMEWORK_DEFAULT_NAME_KEY = "codegen.databinding.frameworks.default";
    private static final String DATA_BINDING_FRAMEWORK_EXTENSION_NAME_KEY = "codegen.databinding.extensions";
    private static final String DATA_BINDING_TEMPLATE_NAME_KEY_PREFIX = "codegen.databinding.";
    private static final String DATA_BINDING_TEMPLATE_NAME_KEY_SUFFIX = "template";
    private static final String DATA_BINDING_TEST_OBJECT_TEMPLATE_NAME_KEY = "codegen.databinding.testobject.template";
    private static final String SOURCE_FOLDER_NAME_KEY = "codegen.general.src.name";
    private static final String RESOURCE_FOLDER_NAME_KEY = "codegen.general.resource.name";
    public static final String DEFAULT_CODEGEN_CONFIG_PROPERTIES = "/org/apache/axis2/wsdl/codegen/codegen-config.properties";
    private static final String SEPARATOR_CHAR = ",";

    private static InputStream getStream(String propertiesReference) throws FileNotFoundException {
        InputStream stream = ConfigPropertyFileLoader.class.getResourceAsStream(propertiesReference);
        if (stream == null) {
            URL url = ConfigPropertyFileLoader.class.getResource(propertiesReference);
            stream = new FileInputStream(url.toString());
        }
        return stream;
    }

    public static void reload() {
        ConfigPropertyFileLoader.reset();
        ConfigPropertyFileLoader.loadAllProperties();
    }

    private static void reset() {
        dbSupporterTemplateNameMap = new HashMap();
        testObjectTemplateName = null;
        extensionClassNames = null;
        thirdPartySchemaNames = null;
        languageTypes = null;
        databindingFrameworkNames = null;
        languageEmitterMap = null;
        languageSpecificPropertiesMap = null;
        databindingFrameworkNameToExtensionMap = null;
        defaultLanguage = null;
        defaultDBFrameworkName = null;
        srcFolderName = null;
        resourceFolderName = null;
    }

    private static void loadAllProperties() {
        try {
            String property = System.getProperty("org.apache.axis2.codegen.config");
            InputStream stream = property != null ? ConfigPropertyFileLoader.getStream(property) : ConfigPropertyFileLoader.getStream(DEFAULT_CODEGEN_CONFIG_PROPERTIES);
            if (stream == null) {
                throw new RuntimeException(CodegenMessages.getMessage("propfileload.generalException"));
            }
            Properties props = new Properties();
            props.load(stream);
            languageSpecificPropertiesMap = new HashMap();
            databindingFrameworkNameToExtensionMap = new HashMap();
            String tempString = props.getProperty(CODE_GEN_KEY_PREFIX);
            if (tempString != null) {
                extensionClassNames = tempString.split(SEPARATOR_CHAR);
            }
            if ((tempString = props.getProperty(POST_CODE_GEN_KEY_PREFIX)) != null) {
                postExtensionClassNames = tempString.split(SEPARATOR_CHAR);
            }
            if ((tempString = props.getProperty(DATA_BINDING_FRAMEWORK_NAME_KEY)) != null) {
                databindingFrameworkNames = tempString.split(SEPARATOR_CHAR);
            }
            if ((tempString = props.getProperty(DATA_BINDING_UNWRAP_SUPPORTED_FRAMEWORK_NAME_KEY)) != null) {
                unwrapSuppoerteddatabindingFrameworkNames = tempString.split(SEPARATOR_CHAR);
            }
            if ((tempString = props.getProperty(DATA_BINDING_UNWRAP_DIRECT_FRAMEWORK_NAME_KEY)) != null) {
                unwrapDirectdatabindingFrameworkNames = tempString.split(SEPARATOR_CHAR);
            }
            if ((tempString = props.getProperty(SOURCE_FOLDER_NAME_KEY)) != null) {
                srcFolderName = tempString;
            }
            if ((tempString = props.getProperty(RESOURCE_FOLDER_NAME_KEY)) != null) {
                resourceFolderName = tempString;
            }
            if ((tempString = props.getProperty(DATA_BINDING_FRAMEWORK_EXTENSION_NAME_KEY)) != null) {
                String[] frameworkExtensionNames = tempString.split(SEPARATOR_CHAR);
                try {
                    for (int i = 0; i < frameworkExtensionNames.length; ++i) {
                        databindingFrameworkNameToExtensionMap.put(databindingFrameworkNames[i], frameworkExtensionNames[i]);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new Exception(CodegenMessages.getMessage("propfileload.frameworkMismatch"));
                }
            }
            if ((tempString = props.getProperty(DATA_BINDING_FRAMEWORK_DEFAULT_NAME_KEY)) == null || !databindingFrameworkNameToExtensionMap.containsKey(tempString)) {
                throw new Exception(CodegenMessages.getMessage("propfileload.unknownFramework"));
            }
            defaultDBFrameworkName = tempString;
            tempString = props.getProperty(THIRD_PARTY_SCHEMA_KEY_PREFIX);
            if (tempString != null) {
                thirdPartySchemaNames = tempString.split(SEPARATOR_CHAR);
            }
            dbSupporterTemplateNameMap = new HashMap();
            Iterator<Object> allProperties = props.keySet().iterator();
            while (allProperties.hasNext()) {
                String key = (String)allProperties.next();
                if (!key.startsWith(DATA_BINDING_TEMPLATE_NAME_KEY_PREFIX) || !key.endsWith(DATA_BINDING_TEMPLATE_NAME_KEY_SUFFIX)) continue;
                dbSupporterTemplateNameMap.put(key, props.getProperty(key));
            }
            testObjectTemplateName = props.getProperty(DATA_BINDING_TEST_OBJECT_TEMPLATE_NAME_KEY);
            tempString = props.getProperty(LANGUAGE_TYPE_KEY_PREFIX);
            if (tempString != null) {
                languageTypes = tempString.split(SEPARATOR_CHAR);
                tempString = props.getProperty(EMITTER_CLASS_KEY);
                if (tempString == null) {
                    throw new Exception(CodegenMessages.getMessage("propfileload.emitterMissing"));
                }
                String[] tempClassNames = tempString.split(SEPARATOR_CHAR);
                languageEmitterMap = new HashMap();
                for (int i = 0; i < tempClassNames.length; ++i) {
                    languageEmitterMap.put(languageTypes[i], tempClassNames[i]);
                }
            }
            if (null == (tempString = props.getProperty(DEFAULT_LANGUAGE_TYPE_KEY)) || !languageEmitterMap.containsKey(tempString)) {
                throw new Exception(CodegenMessages.getMessage("propfileload.unknownDefaultLang"));
            }
            defaultLanguage = tempString;
            for (int i = 0; i < languageTypes.length; ++i) {
                String languageType = languageTypes[i];
                HashMap<String, Object> langSpecificMap = new HashMap<String, Object>();
                Enumeration<Object> keyEnum = props.keys();
                while (keyEnum.hasMoreElements()) {
                    String tempkey = keyEnum.nextElement().toString();
                    if (!tempkey.startsWith(languageType + ".")) continue;
                    langSpecificMap.put(tempkey, props.get(tempkey));
                }
                languageSpecificPropertiesMap.put(languageType, langSpecificMap);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(CodegenMessages.getMessage("propfileload.generalException"), e);
        }
    }

    public static String getResourceFolderName() {
        return resourceFolderName;
    }

    public static String getSrcFolderName() {
        return srcFolderName;
    }

    public static String getTestObjectTemplateName() {
        return testObjectTemplateName;
    }

    public static Map getDbSupporterTemplatesMap() {
        return dbSupporterTemplateNameMap;
    }

    public static String[] getExtensionClassNames() {
        return extensionClassNames;
    }

    public static String[] getPostExtensionClassNames() {
        return postExtensionClassNames;
    }

    public static String[] getThirdPartySchemaNames() {
        return thirdPartySchemaNames;
    }

    public static String[] getLanguageTypes() {
        return languageTypes;
    }

    public static Map getLanguageEmitterMap() {
        return languageEmitterMap;
    }

    public static List getUnwrapSupportedFrameworkNames() {
        return Arrays.asList(unwrapSuppoerteddatabindingFrameworkNames);
    }

    public static List getUnwrapDirectFrameworkNames() {
        return Arrays.asList(unwrapDirectdatabindingFrameworkNames);
    }

    public static String getDefaultLanguage() {
        return defaultLanguage;
    }

    public static Map getLanguageSpecificPropertiesMap() {
        return languageSpecificPropertiesMap;
    }

    public static String[] getDatabindingFrameworkNames() {
        return databindingFrameworkNames;
    }

    public static Map getDatabindingFrameworkNameToExtensionMap() {
        return databindingFrameworkNameToExtensionMap;
    }

    public static String getDefaultDBFrameworkName() {
        return defaultDBFrameworkName;
    }

    static {
        ConfigPropertyFileLoader.loadAllProperties();
    }
}

