/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.ApiSelector
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonOld


final def airPluginTool = new AirPluginTool(args[0], args[1])
final def props = airPluginTool.getStepProperties()

def changeRequestId = props['changeRequestId']
def status = props['status']

def parsedApproval

println "Checking request with number ${changeRequestId}"
println "Checking for status ${status}"
println ""

def newAPI = ApiSelector.selectApi(airPluginTool)

if (newAPI) {
    HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airPluginTool)
    parsedApproval = helper.getApproval()
}
else {
    HelperRestClientJsonOld helperOld = new HelperRestClientJsonOld(airPluginTool)
    parsedApproval = helperOld.getApproval()
}

if (status.equalsIgnoreCase(parsedApproval)) {
    println "Success! Approval status matches ${parsedApproval}"
    System.exit(0)
}
else {
    println "Approval status, ${parsedApproval}, is not the specified approval status ${status}. Exiting failure."
    System.exit(1)
}
