/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

package com.urbancode.air.plugin.servicenow

public class ApiSelector {

    public static boolean selectApi (def airPluginToolIn) {
        def airPluginTool = airPluginToolIn
        def props = airPluginTool.getStepProperties()

        def serviceNowReleaseName = props ['serviceNowReleaseName']

        serviceNowReleaseName = serviceNowReleaseName.toLowerCase()
        if (serviceNowReleaseName.equals('eureka') || serviceNowReleaseName.equals('fuji') ||
            serviceNowReleaseName.equals('geneva') || serviceNowReleaseName.equals('helsinki') ||
            serviceNowReleaseName.equals('istanbul')) {
            println "Using REST API version one for Eureka and above."
            return true
        }
        else if (serviceNowReleaseName.equals('dublin')) {
            println "Using old Dublin REST API."
            return false
        }
        else {
            println ("This plugin does not currently support: " + serviceNowReleaseName )
            System.exit(1)
        }
    }
}