/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.ApiSelector
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonOld

final def airPluginTool = new AirPluginTool(args[0], args[1])
final def props = airPluginTool.getStepProperties()

def changeRequestId = props['changeRequestId']
def status = props['status']

Integer reportedStatus

println "Checking request with number ${changeRequestId}"
println "Checking for Status ${status}"
println ""

def newAPI = ApiSelector.selectApi(airPluginTool)

if (newAPI) {
    HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airPluginTool)
    reportedStatus = helper.getStatus()
}
else {
    HelperRestClientJsonOld helperOld = new HelperRestClientJsonOld(airPluginTool)
    reportedStatus = helperOld.getStatus()
}

if (reportedStatus != Integer.valueOf(status)) {
    println "Reported Status, ${reportedStatus} is not equal to ${status}!"
    System.exit(1)
}
else {
    println "Reported Status matches requested Status, ${status}!"
    System.exit(0)
}
