/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * IBM AnthillPro
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
 import com.urbancode.air.AirPluginTool
 import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1

 final def airPluginTool = new AirPluginTool(args[0], args[1])
 final def props = airPluginTool.getStepProperties()

 def changeRequestId = props['changeRequestId']


 println "Checking request with number ${changeRequestId}"
 println "Checking for deployment window"
 println ""

 HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airPluginTool)
 def deploymentWindow = helper.getDeploymentWindow()

 def currentTime = new Date()

 if (currentTime < deploymentWindow[0]) {
     println "[Error] Current time of ${currentTime} is before change start date ${deploymentWindow[0]}"
     System.exit(1)
 }
 else if(currentTime > deploymentWindow[1]) {
     println "[Error] Current time of ${currentTime} is past change end date ${deploymentWindow[1]}"
     System.exit(1)
 }
 else {
     println "[Ok] Current time falls within the start and end date of change request"
     System.exit(0)
 }
