/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1


final def airPluginTool = new AirPluginTool(args[0], args[1])
final def props = airPluginTool.getStepProperties()

def changeRequestId = props['changeRequestId']
def status = props['status']

def parsedApproval

println "Checking request with number ${changeRequestId}"
println "Checking for status ${status}"
println ""

HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airPluginTool)
parsedApproval = helper.getApproval()

if (status.equalsIgnoreCase(parsedApproval)) {
    println "Success! Approval status matches ${parsedApproval}"
    System.exit(0)
}
else {
    println "Approval status, ${parsedApproval}, is not the specified approval status ${status}. Exiting failure."
    System.exit(1)
}
