/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.ArrayList;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.client.cache.WarningValue;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicHeader;

@Immutable
class ResponseProtocolCompliance {
    ResponseProtocolCompliance() {
    }

    public void ensureProtocolCompliance(HttpRequest request, HttpResponse response) throws ClientProtocolException {
        if (this.backendResponseMustNotHaveBody(request, response)) {
            response.setEntity(null);
        }
        this.authenticationRequiredDidNotHaveAProxyAuthenticationHeader(request, response);
        this.notAllowedResponseDidNotHaveAnAllowHeader(request, response);
        this.unauthorizedResponseDidNotHaveAWWWAuthenticateHeader(request, response);
        this.requestDidNotExpect100ContinueButResponseIsOne(request, response);
        this.transferEncodingIsNotReturnedTo1_0Client(request, response);
        this.ensurePartialContentIsNotSentToAClientThatDidNotRequestIt(request, response);
        this.ensure200ForOPTIONSRequestWithNoBodyHasContentLengthZero(request, response);
        this.ensure206ContainsDateHeader(response);
        this.ensure304DoesNotContainExtraEntityHeaders(response);
        this.identityIsNotUsedInContentEncoding(response);
        this.warningsWithNonMatchingWarnDatesAreRemoved(response);
    }

    private void warningsWithNonMatchingWarnDatesAreRemoved(HttpResponse response) {
        Date responseDate = null;
        try {
            responseDate = DateUtils.parseDate((String)response.getFirstHeader("Date").getValue());
        }
        catch (DateParseException e) {
            // empty catch block
        }
        if (responseDate == null) {
            return;
        }
        Header[] warningHeaders = response.getHeaders("Warning");
        if (warningHeaders == null || warningHeaders.length == 0) {
            return;
        }
        ArrayList<BasicHeader> newWarningHeaders = new ArrayList<BasicHeader>();
        boolean modified = false;
        for (Header h : warningHeaders) {
            for (WarningValue wv : WarningValue.getWarningValues(h)) {
                Date warnDate = wv.getWarnDate();
                if (warnDate == null || warnDate.equals(responseDate)) {
                    newWarningHeaders.add(new BasicHeader("Warning", wv.toString()));
                    continue;
                }
                modified = true;
            }
        }
        if (modified) {
            response.removeHeaders("Warning");
            for (Header header : newWarningHeaders) {
                response.addHeader(header);
            }
        }
    }

    private void identityIsNotUsedInContentEncoding(HttpResponse response) {
        Header[] hdrs = response.getHeaders("Content-Encoding");
        if (hdrs == null || hdrs.length == 0) {
            return;
        }
        ArrayList<BasicHeader> newHeaders = new ArrayList<BasicHeader>();
        boolean modified = false;
        for (Header h : hdrs) {
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (HeaderElement elt : h.getElements()) {
                if ("identity".equalsIgnoreCase(elt.getName())) {
                    modified = true;
                    continue;
                }
                if (!first) {
                    buf.append(",");
                }
                buf.append(elt.toString());
                first = false;
            }
            String newHeaderValue = buf.toString();
            if ("".equals(newHeaderValue)) continue;
            newHeaders.add(new BasicHeader("Content-Encoding", newHeaderValue));
        }
        if (!modified) {
            return;
        }
        response.removeHeaders("Content-Encoding");
        for (Header header : newHeaders) {
            response.addHeader(header);
        }
    }

    private void authenticationRequiredDidNotHaveAProxyAuthenticationHeader(HttpRequest request, HttpResponse response) throws ClientProtocolException {
        if (response.getStatusLine().getStatusCode() != 407) {
            return;
        }
        if (response.getFirstHeader("Proxy-Authenticate") == null) {
            throw new ClientProtocolException("407 Response did not contain a Proxy-Authentication header");
        }
    }

    private void notAllowedResponseDidNotHaveAnAllowHeader(HttpRequest request, HttpResponse response) throws ClientProtocolException {
        if (response.getStatusLine().getStatusCode() != 405) {
            return;
        }
        if (response.getFirstHeader("Allow") == null) {
            throw new ClientProtocolException("405 Response did not contain an Allow header.");
        }
    }

    private void unauthorizedResponseDidNotHaveAWWWAuthenticateHeader(HttpRequest request, HttpResponse response) throws ClientProtocolException {
        if (response.getStatusLine().getStatusCode() != 401) {
            return;
        }
        if (response.getFirstHeader("WWW-Authenticate") == null) {
            throw new ClientProtocolException("401 Response did not contain required WWW-Authenticate challenge header");
        }
    }

    private void ensure206ContainsDateHeader(HttpResponse response) {
        if (response.getFirstHeader("Date") == null) {
            response.addHeader("Date", DateUtils.formatDate((Date)new Date()));
        }
    }

    private void ensurePartialContentIsNotSentToAClientThatDidNotRequestIt(HttpRequest request, HttpResponse response) throws ClientProtocolException {
        if (request.getFirstHeader("Range") != null) {
            return;
        }
        if (response.getFirstHeader("Content-Range") != null) {
            throw new ClientProtocolException("Content-Range was returned for a request that did not ask for a Content-Range.");
        }
    }

    private void ensure200ForOPTIONSRequestWithNoBodyHasContentLengthZero(HttpRequest request, HttpResponse response) {
        if (!request.getRequestLine().getMethod().equalsIgnoreCase("OPTIONS")) {
            return;
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            return;
        }
        if (response.getFirstHeader("Content-Length") == null) {
            response.addHeader("Content-Length", "0");
        }
    }

    private void ensure304DoesNotContainExtraEntityHeaders(HttpResponse response) {
        String[] disallowedEntityHeaders = new String[]{"Allow", "Content-Encoding", "Content-Language", "Content-Length", "Content-MD5", "Content-Range", "Content-Type", "Last-Modified"};
        if (response.getStatusLine().getStatusCode() == 304) {
            for (String hdr : disallowedEntityHeaders) {
                response.removeHeaders(hdr);
            }
        }
    }

    private boolean backendResponseMustNotHaveBody(HttpRequest request, HttpResponse backendResponse) {
        return "HEAD".equals(request.getRequestLine().getMethod()) || backendResponse.getStatusLine().getStatusCode() == 204 || backendResponse.getStatusLine().getStatusCode() == 205 || backendResponse.getStatusLine().getStatusCode() == 304;
    }

    private void requestDidNotExpect100ContinueButResponseIsOne(HttpRequest request, HttpResponse response) throws ClientProtocolException {
        if (response.getStatusLine().getStatusCode() != 100) {
            return;
        }
        if (!this.requestWasWrapped(request)) {
            return;
        }
        ProtocolVersion originalProtocol = this.getOriginalRequestProtocol((RequestWrapper)request);
        if (originalProtocol.compareToVersion((ProtocolVersion)HttpVersion.HTTP_1_1) >= 0) {
            return;
        }
        if (this.originalRequestDidNotExpectContinue((RequestWrapper)request)) {
            throw new ClientProtocolException("The incoming request did not contain a 100-continue header, but the response was a Status 100, continue.");
        }
    }

    private void transferEncodingIsNotReturnedTo1_0Client(HttpRequest request, HttpResponse response) {
        if (!this.requestWasWrapped(request)) {
            return;
        }
        ProtocolVersion originalProtocol = this.getOriginalRequestProtocol((RequestWrapper)request);
        if (originalProtocol.compareToVersion((ProtocolVersion)HttpVersion.HTTP_1_1) >= 0) {
            return;
        }
        this.removeResponseTransferEncoding(response);
    }

    private void removeResponseTransferEncoding(HttpResponse response) {
        response.removeHeaders("TE");
        response.removeHeaders("Transfer-Encoding");
    }

    private boolean originalRequestDidNotExpectContinue(RequestWrapper request) {
        try {
            HttpEntityEnclosingRequest original = (HttpEntityEnclosingRequest)request.getOriginal();
            return !original.expectContinue();
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    private ProtocolVersion getOriginalRequestProtocol(RequestWrapper request) {
        return request.getOriginal().getProtocolVersion();
    }

    private boolean requestWasWrapped(HttpRequest request) {
        return request instanceof RequestWrapper;
    }
}

