package com.urbancode.air.plugin.servicenow
import com.urbancode.air.AirPluginTool
import groovy.util.slurpersupport.GPathResult
import static groovyx.net.http.ContentType.*
import static groovyx.net.http.Method.*
import groovyx.net.http.*

public class JsonHelper {
    
    def apTool
    def props = []
    def serverUrl
    def username
    def password
    def auth
    def client
    
    public JsonHelper(def apToolIn) {
        apTool = apToolIn
        props = apTool.getStepProperties()
        serverUrl = props['serverUrl']
        username = props['username']
        password = props['password']
        
        while (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1)
        }
        
        client = new HTTPBuilder(serverUrl)
        auth = new AuthConfig(client)
        auth.basic(username, password)
        client.setAuthConfig(auth)
    }
    
    def insertRow() {
        def tableName = props['table']
        def unparsedFields = props['fields']
        def fields = [:]
        
        if(!tableName) {
            throw new IllegalArgumentException("no table name was specified!")
        }
        
        def nameValuePairs = unparsedFields.split("\n")
        nameValuePairs.each{nameValue->
            try {
                def delim = nameValue.indexOf(":")
                def name = nameValue.substring(0, delim)
                def value = nameValue.substring(delim+1)
                fields[name] = value
            }
            catch(IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("the syntax of your input field was incorrect for field $nameValue")
            }
        }
        
        client.request( POST, JSON ) { req ->
            uri.path = "/${tableName}.do?JSON&sysparm_action=insert"
            body = fields
            
            response.success = { resp, json ->
                println "Successfully inserted row. Response status: ${resp.statusLine}"
            }
        }
        
    }
    
    def deleteRow() {
        def tableName = props['table']
        def id = props['id']
        
        if(!tableName) {
            throw new IllegalArgumentException("no table name was specified!")
        }
        if(!id) {
            throw new IllegalArgumentException("no ID was specified!")
        }
        
        def bodyToSend = ['sysparm_sys_id':id]
        
        client.request( POST, JSON ) { req ->
            uri.path = "/${tableName}.do?JSON&sysparm_action=deleteRecord"
            body = bodyToSend
            
            response.success = { resp, json ->
                println "Successfully deleted row. Response status: ${resp.statusLine}"
            }
        }
    }
    
    def deleteMultipleRows() {
        def tableName = props['table']
        def condition = props['condition']
        
        if(!tableName) {
            throw new IllegalArgumentException("no table name was specified!")
        }
        if(!condition) {
            throw new IllegalArgumentException("no condition was specified!")
        }
        
        def bodyToSend = ['sysparm_query':condition]
        
        client.request( POST, JSON ) { req ->
            uri.path = "/${tableName}.do?JSON&sysparm_action=deleteMultiple"
            body = bodyToSend
            
            response.success = { resp, json ->
                println "Successfully deleted rows. Response status: ${resp.statusLine}"
            }
        }
    }
}