import com.urbancode.air.AirPluginTool
import com.urbancode.air.XTrustProvider
import com.urbancode.plugin.servicenow.changetask.ServiceNow_change_taskStub
import org.apache.axis2.transport.http.HttpTransportProperties

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

XTrustProvider.install();

def serverUrl = props['serverUrl'];
def username = props['username'];
def password = props['passwordScript']?props['passwordScript']:props['password'];
def proxyHost = props['proxyHost'];
def proxyPort = props['proxyPort'];
def proxyUser = props['proxyUser'];
def proxyPass = props['proxyPass'];
def proxyPassScript = props['proxyPassScript'];
def tasksIds = props['tasksId'];
def status = props['status'];

if (serverUrl.startsWith("https://")) {
    serverUrl = serverUrl.substring(8);
}

if (serverUrl.startsWith("http://")) {
    serverUrl = serverUrl.substring(7);
}

while (serverUrl.endsWith("/")) {
    serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
}

def taskServerUrl = "https://" + serverUrl + "/change_task.do?SOAP";


HttpTransportProperties.Authenticator basicAuth = new HttpTransportProperties.Authenticator();
println "Using serverUrl ${serverUrl}";
println "Using username ${username}";
println "Using password ${password}";
println "Using Proxy Host ${proxyHost}";
println "Using Proxy Port ${proxyPort}";
println "Using Proxy User ${proxyUser}";
println "Updating task Ids with number ${tasksIds}";
println "Updating with status ${status}";
basicAuth.setUsername(username);
basicAuth.setPassword(password);

ServiceNow_change_taskStub taskStub = new ServiceNow_change_taskStub(taskServerUrl);
taskStub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.CHUNKED, Boolean.FALSE);
taskStub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.AUTHENTICATE, basicAuth);

if (proxyHost && proxyHost.trim().length() > 0) {
    HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
    proxyProperties.setProxyName(proxyHost.trim())
    if (proxyPort && proxyPort.trim().length() > 0) {
        proxyProperties.setProxyPort(proxyPort.toInteger())
    }
    if (proxyUser && proxyUser.trim().length() > 0) {
        proxyProperties.setUserName(proxyUser.trim())
    }
    if (proxyPassScript && proxyPassScript.trim().length() > 0) {
        proxyProperties.setPassWord(proxyPassScript)
    }
    else if (proxyPass && proxyPass.trim().length() > 0){
        proxyProperties.setPassWord(proxyPass)
    }
    taskStub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.PROXY, proxyProperties)
}

String tasks = tasksIds;

tasks.split(',').each { taskId ->
    println ""
    //for each task check status report bad ones
    if (!taskId || taskId.trim() == "") {
        return;
    }
    println "Updating Task ${taskId}";
    ServiceNow_change_taskStub.Update taskUpdater = new ServiceNow_change_taskStub.Update();
    taskUpdater.setSys_id(taskId);
    taskUpdater.setState(new BigInteger(status));
    
    ServiceNow_change_taskStub.UpdateResponse taskResp = new ServiceNow_change_taskStub.UpdateResponse();
    try {
        taskResp = taskStub.update(taskUpdater);
    }
    catch (Exception e) {
        e.printStackTrace();
        throw e;
    }

    if (taskResp == null) {
       throw new Exception("Failed to update task state!");
    }
}

println ""
println "**********************************************************************************";
println ""

println "All task statuses updated to ${status}!";
System.exit(0);
