/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovyx.net.http.ContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.message.BasicHeader;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.groovy.runtime.MethodClosure;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRegistry {
    protected final Closure DEFAULT_PARSER;
    public static final String DEFAULT_CHARSET = "UTF-8";
    private Closure defaultParser;
    private Map<String, Closure> registeredParsers;
    private static String defaultCharset = "UTF-8";
    protected static final Log log = LogFactory.getLog(ParserRegistry.class);
    protected static CatalogResolver catalogResolver;

    public ParserRegistry() {
        this.defaultParser = this.DEFAULT_PARSER = new MethodClosure((Object)this, "parseStream");
        this.registeredParsers = this.buildDefaultParserMap();
    }

    public static void setDefaultCharset(String charset) {
        defaultCharset = charset == null ? DEFAULT_CHARSET : charset;
    }

    public static String getCharset(HttpResponse resp) {
        try {
            NameValuePair charset = resp.getEntity().getContentType().getElements()[0].getParameterByName("charset");
            if (charset == null || charset.getValue().trim().equals("")) {
                log.debug((Object)("Could not find charset in response; using " + defaultCharset));
                return defaultCharset;
            }
            return charset.getValue();
        }
        catch (RuntimeException ex) {
            log.warn((Object)"Could not parse charset from content-type header in response");
            return Charset.defaultCharset().name();
        }
    }

    public static String getContentType(HttpResponse resp) {
        if (resp.getEntity() == null) {
            throw new IllegalArgumentException("Response does not contain data");
        }
        if (resp.getEntity().getContentType() == null) {
            throw new IllegalArgumentException("Response does not have a content-type header");
        }
        try {
            return resp.getEntity().getContentType().getElements()[0].getName();
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Could not parse content-type from response");
        }
    }

    public InputStream parseStream(HttpResponse resp) throws IOException {
        return resp.getEntity().getContent();
    }

    public Reader parseText(HttpResponse resp) throws IOException {
        return new InputStreamReader(resp.getEntity().getContent(), ParserRegistry.getCharset(resp));
    }

    public Map<String, String> parseForm(final HttpResponse resp) throws IOException {
        Object entity = resp.getEntity();
        if (!ContentType.URLENC.toString().equals(ParserRegistry.getContentType(resp))) {
            entity = new HttpEntityWrapper((HttpEntity)entity){

                public Header getContentType() {
                    String value = ContentType.URLENC.toString();
                    String charset = ParserRegistry.getCharset(resp);
                    if (charset != null) {
                        value = value + "; charset=" + charset;
                    }
                    return new BasicHeader("Content-Type", value);
                }
            };
        }
        List params = URLEncodedUtils.parse((HttpEntity)entity);
        HashMap<String, String> paramMap = new HashMap<String, String>(params.size());
        for (NameValuePair param : params) {
            paramMap.put(param.getName(), param.getValue());
        }
        return paramMap;
    }

    public GPathResult parseHTML(HttpResponse resp) throws IOException, SAXException {
        SAXParser p = new SAXParser();
        p.setEntityResolver((EntityResolver)catalogResolver);
        return new XmlSlurper((XMLReader)p).parse(this.parseText(resp));
    }

    public GPathResult parseXML(HttpResponse resp) throws IOException, SAXException, ParserConfigurationException {
        XmlSlurper xml = new XmlSlurper();
        xml.setEntityResolver((EntityResolver)catalogResolver);
        return xml.parse(this.parseText(resp));
    }

    public Object parseJSON(HttpResponse resp) throws IOException {
        return new JsonSlurper().parse(this.parseText(resp));
    }

    protected Map<String, Closure> buildDefaultParserMap() {
        HashMap<String, Closure> parsers = new HashMap<String, Closure>();
        parsers.put(ContentType.BINARY.toString(), (Closure)new MethodClosure((Object)this, "parseStream"));
        parsers.put(ContentType.TEXT.toString(), (Closure)new MethodClosure((Object)this, "parseText"));
        parsers.put(ContentType.URLENC.toString(), (Closure)new MethodClosure((Object)this, "parseForm"));
        parsers.put(ContentType.HTML.toString(), (Closure)new MethodClosure((Object)this, "parseHTML"));
        MethodClosure pClosure = new MethodClosure((Object)this, "parseXML");
        for (String ct : ContentType.XML.getContentTypeStrings()) {
            parsers.put(ct, (Closure)pClosure);
        }
        pClosure = new MethodClosure((Object)this, "parseJSON");
        for (String ct : ContentType.JSON.getContentTypeStrings()) {
            parsers.put(ct, (Closure)pClosure);
        }
        return parsers;
    }

    public static void addCatalog(URL catalogLocation) throws IOException {
        catalogResolver.getCatalog().parseCatalog(catalogLocation);
    }

    public static CatalogResolver getCatalogResolver() {
        return catalogResolver;
    }

    public Closure getDefaultParser() {
        return this.defaultParser;
    }

    public void setDefaultParser(Closure defaultParser) {
        if (defaultParser == null) {
            this.defaultParser = this.DEFAULT_PARSER;
        }
        this.defaultParser = defaultParser;
    }

    public Closure getAt(Object contentType) {
        Closure parser;
        String ct = contentType.toString();
        int idx = ct.indexOf(59);
        if (idx > 0) {
            ct = ct.substring(0, idx);
        }
        if ((parser = this.registeredParsers.get(ct)) != null) {
            return parser;
        }
        log.warn((Object)("Cannot find parser for content-type: " + ct + " -- using default parser."));
        return this.defaultParser;
    }

    public void putAt(Object contentType, Closure value) {
        if (contentType instanceof ContentType) {
            for (String ct : ((ContentType)((Object)contentType)).getContentTypeStrings()) {
                this.registeredParsers.put(ct, value);
            }
        } else {
            this.registeredParsers.put(contentType.toString(), value);
        }
    }

    public Closure propertyMissing(Object key) {
        return this.getAt(key);
    }

    public void propertyMissing(Object key, Closure value) {
        this.putAt(key, value);
    }

    public Iterator<Map.Entry<String, Closure>> iterator() {
        return this.registeredParsers.entrySet().iterator();
    }

    static {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setUseStaticCatalog(false);
        catalogManager.setRelativeCatalogs(true);
        try {
            catalogResolver = new CatalogResolver(catalogManager);
            catalogResolver.getCatalog().parseCatalog(ParserRegistry.class.getResource("/catalog/html.xml"));
        }
        catch (IOException ex) {
            LogFactory.getLog(ParserRegistry.class).warn((Object)"Could not resolve default XML catalog", (Throwable)ex);
        }
    }
}

