/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.Writable;
import groovy.util.Expando;
import groovy.xml.StreamingMarkupBuilder;
import groovyx.net.http.ContentType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MethodClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncoderRegistry {
    Charset charset = Charset.defaultCharset();
    private Map<String, Closure> registeredEncoders = this.buildDefaultEncoderMap();

    public void setCharset(String charset) {
        this.charset = Charset.forName(charset);
    }

    public InputStreamEntity encodeStream(Object data, Object contentType) throws UnsupportedEncodingException {
        InputStreamEntity entity = null;
        if (data instanceof ByteArrayInputStream) {
            ByteArrayInputStream in = (ByteArrayInputStream)data;
            entity = new InputStreamEntity((InputStream)in, (long)in.available());
        } else if (data instanceof InputStream) {
            entity = new InputStreamEntity((InputStream)data, -1L);
        } else if (data instanceof byte[]) {
            byte[] out = (byte[])data;
            entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(out), (long)out.length);
        } else if (data instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream out = (ByteArrayOutputStream)data;
            entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(out.toByteArray()), (long)out.size());
        } else if (data instanceof Closure) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ((Closure)data).call((Object)out);
            entity = new InputStreamEntity((InputStream)new ByteArrayInputStream(out.toByteArray()), (long)out.size());
        }
        if (entity == null) {
            throw new IllegalArgumentException("Don't know how to encode " + data + " as a byte stream");
        }
        if (contentType == null) {
            contentType = ContentType.BINARY;
        }
        entity.setContentType(contentType.toString());
        return entity;
    }

    public HttpEntity encodeText(Object data, Object contentType) throws IOException {
        StringWriter out;
        if (data instanceof Closure) {
            out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            ((Closure)data).call((Object)writer);
            writer.close();
            out.flush();
            data = out;
        } else if (data instanceof Writable) {
            out = new StringWriter();
            ((Writable)data).writeTo((Writer)out);
            out.flush();
            data = out;
        } else if (data instanceof Reader && !(data instanceof BufferedReader)) {
            data = new BufferedReader((Reader)data);
        }
        if (data instanceof BufferedReader) {
            out = new StringWriter();
            DefaultGroovyMethods.leftShift((Writer)out, (Object)((BufferedReader)data));
            data = out;
        }
        if (contentType == null) {
            contentType = ContentType.TEXT;
        }
        return this.createEntity(contentType, data.toString());
    }

    public UrlEncodedFormEntity encodeForm(Map<?, ?> params) throws UnsupportedEncodingException {
        return this.encodeForm(params, null);
    }

    public UrlEncodedFormEntity encodeForm(Map<?, ?> params, Object contentType) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
        for (Object key : params.keySet()) {
            Object val = params.get(key);
            if (val instanceof List) {
                for (Object subVal : (List)val) {
                    paramList.add(new BasicNameValuePair(key.toString(), subVal == null ? "" : subVal.toString()));
                }
                continue;
            }
            paramList.add(new BasicNameValuePair(key.toString(), val == null ? "" : val.toString()));
        }
        UrlEncodedFormEntity e = new UrlEncodedFormEntity(paramList, this.charset.name());
        if (contentType != null) {
            e.setContentType(contentType.toString());
        }
        return e;
    }

    public HttpEntity encodeForm(String formData, Object contentType) throws UnsupportedEncodingException {
        if (contentType == null) {
            contentType = ContentType.URLENC;
        }
        return this.createEntity(contentType, formData);
    }

    public HttpEntity encodeXML(Object xml, Object contentType) throws UnsupportedEncodingException {
        if (xml instanceof Closure) {
            StreamingMarkupBuilder smb = new StreamingMarkupBuilder();
            xml = smb.bind(xml);
        }
        if (contentType == null) {
            contentType = ContentType.XML;
        }
        return this.createEntity(contentType, xml.toString());
    }

    public HttpEntity encodeJSON(Object model, Object contentType) throws UnsupportedEncodingException {
        String json;
        if (model instanceof Map) {
            json = JsonOutput.toJson((Map)((Map)model));
        } else if (model instanceof Closure) {
            Closure closure = (Closure)model;
            Expando object = new Expando();
            closure.setDelegate((Object)object);
            closure.setResolveStrategy(3);
            closure.call();
            json = JsonOutput.toJson((Object)object);
        } else {
            json = model instanceof String || model instanceof GString ? model.toString() : JsonOutput.toJson((Object)model);
        }
        if (contentType == null) {
            contentType = ContentType.JSON;
        }
        return this.createEntity(contentType, json);
    }

    protected StringEntity createEntity(Object ct, String data) throws UnsupportedEncodingException {
        StringEntity entity = new StringEntity(data, this.charset.toString());
        entity.setContentType(ct.toString());
        return entity;
    }

    protected Map<String, Closure> buildDefaultEncoderMap() {
        HashMap<String, Closure> encoders = new HashMap<String, Closure>();
        encoders.put(ContentType.BINARY.toString(), (Closure)new MethodClosure((Object)this, "encodeStream"));
        encoders.put(ContentType.TEXT.toString(), (Closure)new MethodClosure((Object)this, "encodeText"));
        encoders.put(ContentType.URLENC.toString(), (Closure)new MethodClosure((Object)this, "encodeForm"));
        MethodClosure encClosure = new MethodClosure((Object)this, "encodeXML");
        for (String ct : ContentType.XML.getContentTypeStrings()) {
            encoders.put(ct, (Closure)encClosure);
        }
        encoders.put(ContentType.HTML.toString(), (Closure)encClosure);
        encClosure = new MethodClosure((Object)this, "encodeJSON");
        for (String ct : ContentType.JSON.getContentTypeStrings()) {
            encoders.put(ct, (Closure)encClosure);
        }
        return encoders;
    }

    public Closure getAt(Object contentType) {
        String ct = contentType.toString();
        int idx = ct.indexOf(59);
        if (idx > 0) {
            ct = ct.substring(0, idx);
        }
        return this.registeredEncoders.get(ct);
    }

    public void putAt(Object contentType, Closure value) {
        if (contentType instanceof ContentType) {
            for (String ct : ((ContentType)((Object)contentType)).getContentTypeStrings()) {
                this.registeredEncoders.put(ct, value);
            }
        } else {
            this.registeredEncoders.put(contentType.toString(), value);
        }
    }

    public Closure propertyMissing(Object key) {
        return this.getAt(key);
    }

    public void propertyMissing(Object key, Closure value) {
        this.putAt(key, value);
    }

    public Iterator<Map.Entry<String, Closure>> iterator() {
        return this.registeredEncoders.entrySet().iterator();
    }
}

