/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.Header;

public class HeaderGroup {
    private List headers = new ArrayList();

    public void clear() {
        this.headers.clear();
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public void removeHeader(Header header) {
        this.headers.remove(header);
    }

    public void setHeaders(Header[] headerArray) {
        this.clear();
        for (int i = 0; i < headerArray.length; ++i) {
            this.addHeader(headerArray[i]);
        }
    }

    public Header getCondensedHeader(String string) {
        Header[] headerArray = this.getHeaders(string);
        if (headerArray.length == 0) {
            return null;
        }
        if (headerArray.length == 1) {
            return new Header(headerArray[0].getName(), headerArray[0].getValue());
        }
        StringBuffer stringBuffer = new StringBuffer(headerArray[0].getValue());
        for (int i = 1; i < headerArray.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(headerArray[i].getValue());
        }
        return new Header(string.toLowerCase(Locale.ENGLISH), stringBuffer.toString());
    }

    public Header[] getHeaders(String string) {
        ArrayList<Header> arrayList = new ArrayList<Header>();
        for (Header header : this.headers) {
            if (!header.getName().equalsIgnoreCase(string)) continue;
            arrayList.add(header);
        }
        return arrayList.toArray(new Header[arrayList.size()]);
    }

    public Header getFirstHeader(String string) {
        for (Header header : this.headers) {
            if (!header.getName().equalsIgnoreCase(string)) continue;
            return header;
        }
        return null;
    }

    public Header getLastHeader(String string) {
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            Header header = (Header)this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(string)) continue;
            return header;
        }
        return null;
    }

    public Header[] getAllHeaders() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }

    public boolean containsHeader(String string) {
        for (Header header : this.headers) {
            if (!header.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public Iterator getIterator() {
        return this.headers.iterator();
    }
}

