/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.XTrustProvider
import com.urbancode.plugin.servicenow.changerequest.ServiceNow_change_requestStub

import org.apache.axis2.transport.http.HttpTransportProperties

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

XTrustProvider.install()

def changeRequestId = props['changeRequestId']
def proxyHost = props['proxyHost']
def proxyPass = props['proxyPass']
def proxyPort = props['proxyPort']
def proxyUser = props['proxyUser']
def serverUrl = props['serverUrl']
def status = props['status']
def username = props['username']
def password = props['passwordScript']?props['passwordScript']:props['password']
def proxyPassScript = props['proxyPassScript']


if (serverUrl.startsWith("https://")) {
    serverUrl = serverUrl.substring(8)
}
if (serverUrl.startsWith("http://")) {
    serverUrl = serverUrl.substring(7)
}
while (serverUrl.endsWith("/")) {
    serverUrl = serverUrl.substring(0, serverUrl.length() - 1)
}
serverUrl = "https://" + serverUrl + "/change_request.do?SOAP"


HttpTransportProperties.Authenticator basicAuth = new HttpTransportProperties.Authenticator()
println "Using serverUrl ${serverUrl}"
println "Using username ${username}"
println "Using password ${password}"
println "Using Proxy Host ${proxyHost}"
println "Using Proxy Port ${proxyPort}"
println "Using Proxy User ${proxyUser}"
println "Checking request with number ${changeRequestId}"
println "Checking for status ${status}"

basicAuth.setUsername(username)
basicAuth.setPassword(password)

ServiceNow_change_requestStub stub = new ServiceNow_change_requestStub(serverUrl)
//See ServiceNow SOAP Documentation
stub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.CHUNKED, Boolean.FALSE)
stub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.AUTHENTICATE, basicAuth)

if (proxyHost && proxyHost.trim().length() > 0) {
    HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties()
    proxyProperties.setProxyName(proxyHost.trim())
    if (proxyPort && proxyPort.trim().length() > 0) {
        proxyProperties.setProxyPort(proxyPort.toInteger())
    }
    if (proxyUser && proxyUser.trim().length() > 0) {
        proxyProperties.setUserName(proxyUser.trim())
    }
    if (proxyPassScript && proxyPassScript.trim().length() > 0) {
        proxyProperties.setPassWord(proxyPassScript)
    }
    else if (proxyPass && proxyPass.trim().length() > 0) {
        proxyProperties.setPassWord(proxyPass)
    }
    stub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.PROXY, proxyProperties)
}

ServiceNow_change_requestStub.GetKeys keyGetter = new ServiceNow_change_requestStub.GetKeys()
keyGetter.setNumber(changeRequestId)

ServiceNow_change_requestStub.GetKeysResponse keyResp = null
try {
    keyResp = stub.getKeys(keyGetter)
}
catch (Exception e) {
    e.printStackTrace()
    throw e
}

if (Integer.valueOf(keyResp.getCount()) > 1) {
    throw new Exception("found more than one, ${keyResp.getCount()}, change request with number ${changeRequestId}!")
}
else if (Integer.valueOf(keyResp.getCount()) == 0) {
    throw new Exception("Found no change requests with number ${changeRequestId}!")
}

String actualChangeRequestId = keyResp.getSys_id()[0]

ServiceNow_change_requestStub.Get getter = new ServiceNow_change_requestStub.Get()
getter.setSys_id(actualChangeRequestId)

ServiceNow_change_requestStub.GetResponse resp = null
try {
    resp = stub.get(getter)
}
catch (Exception e) {
    e.printStackTrace()
    throw e
}

if (resp == null) {
    throw new Exception("Change request not found to check approval status!")
}
String reportedStatus = resp.getApproval();
if (reportedStatus != status) {
    throw new Exception("Reported status, ${reportedStatus}, not equal to ${status}!")
}

println "Reported approval status matches requested status, ${status}!"

System.exit(0)
