/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.XTrustProvider
import com.urbancode.plugin.servicenow.changerequest.ServiceNow_change_requestStub
import com.urbancode.plugin.servicenow.changetask.ServiceNow_change_taskStub

import org.apache.axis2.transport.http.HttpTransportProperties

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

XTrustProvider.install()

def changeRequestId = props['changeRequestId']
def proxyHost = props['proxyHost']
def proxyPort = props['proxyPort']
def proxyPass = props['proxyPass']
def proxyUser = props['proxyUser']
def serverUrl = props['serverUrl']
def status = props['status']
def username = props['username']
def password = props['passwordScript']?props['passwordScript']:props['password']
def proxyPassScript = props['proxyPassScript']

if (serverUrl.startsWith("https://")) {
    serverUrl = serverUrl.substring(8)
}
if (serverUrl.startsWith("http://")) {
    serverUrl = serverUrl.substring(7)
}
while (serverUrl.endsWith("/")) {
    serverUrl = serverUrl.substring(0, serverUrl.length() - 1)
}
def requestServerUrl = "https://" + serverUrl + "/change_request.do?SOAP"
def taskServerUrl = "https://" + serverUrl + "/change_task.do?SOAP"


HttpTransportProperties.Authenticator basicAuth = new HttpTransportProperties.Authenticator()
println "Using serverUrl ${serverUrl}"
println "Using username ${username}"
println "Using password ${password}"
println "Using Proxy Host ${proxyHost}"
println "Using Proxy Port ${proxyPort}"
println "Using Proxy User ${proxyUser}"
println "Checking request with number ${changeRequestId}"
println "Checking for status ${status}"
basicAuth.setUsername(username)
basicAuth.setPassword(password)

ServiceNow_change_requestStub stub = new ServiceNow_change_requestStub(requestServerUrl)
stub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.CHUNKED, Boolean.FALSE)
stub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.AUTHENTICATE, basicAuth)

if (proxyHost && proxyHost.trim().length() > 0) {
    HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties()
    proxyProperties.setProxyName(proxyHost.trim())
    if (proxyPort && proxyPort.trim().length() > 0) {
        proxyProperties.setProxyPort(proxyPort.toInteger())
    }
    if (proxyUser && proxyUser.trim().length() > 0) {
        proxyProperties.setUserName(proxyUser.trim())
    }
    if (proxyPassScript && proxyPassScript.trim().length() > 0) {
        proxyProperties.setPassWord(proxyPassScript)
    }
    else if (proxyPass && proxyPass.trim().length() > 0) {
        proxyProperties.setPassWord(proxyPass)
    }
    stub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.PROXY, proxyProperties)
}

ServiceNow_change_requestStub.GetKeys keyGetter = new ServiceNow_change_requestStub.GetKeys()
keyGetter.setNumber(changeRequestId)

ServiceNow_change_requestStub.GetKeysResponse keyResp = null
try {
    keyResp = stub.getKeys(keyGetter)
}
catch (Exception e) {
    e.printStackTrace()
    throw e
}

if (Integer.valueOf(keyResp.getCount()) > 1) {
    throw new Exception("found more than one, ${keyResp.getCount()}, change request with number ${changeRequestId}!")
}
else if (Integer.valueOf(keyResp.getCount()) == 0) {
    throw new Exception("Found no change requests with number ${changeRequestId}!")
}

String actualChangeRequestId = keyResp.getSys_id()[0]

println "Got Change Request Id : ${actualChangeRequestId}"

///get the change tasks that declare to be associated with this change request

ServiceNow_change_taskStub taskStub = new ServiceNow_change_taskStub(taskServerUrl)
//See ServiceNow SOAP documentation 
taskStub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.CHUNKED, Boolean.FALSE)
taskStub._getServiceClient().getOptions().setProperty(org.apache.axis2.transport.http.HTTPConstants.AUTHENTICATE, basicAuth)

ServiceNow_change_taskStub.GetKeys taskKeyGetter = new ServiceNow_change_taskStub.GetKeys()
taskKeyGetter.setChange_request(actualChangeRequestId)

ServiceNow_change_taskStub.GetKeysResponse taskKeyResp = null
try {
    taskKeyResp = taskStub.getKeys(taskKeyGetter)
}
catch (Exception e) {
    e.printStackTrace()
    throw e
}

String tasks = taskKeyResp.getSys_id().join(',')

def badStatus = [:]
tasks.split(',').each { taskId ->
    println ""
    //for each task check status report bad ones
    if (!taskId || taskId.trim() == "") {
        return
    }
    println "Checking Task ${taskId}"
    ServiceNow_change_taskStub.Get taskGetter = new ServiceNow_change_taskStub.Get()
    taskGetter.setSys_id(taskId)

    ServiceNow_change_taskStub.GetResponse taskResp = new ServiceNow_change_taskStub.GetResponse()
    try {
        taskResp = taskStub.get(taskGetter)
    }
    catch (Exception e) {
        e.printStackTrace()
        throw e
    }

    if (taskResp == null) {
        badStatus.put(taskId, "Task Not Found")
    }
    else if (taskResp.getState().intValue() != Integer.valueOf(status)) {
        badStatus.put(taskResp.getNumber(), String.valueOf(taskResp.getState().intValue()))
    }
    else {
        println "\tTask " + taskResp.getNumber() + " matches status ${status}!"
    }
}

println ""
println "**********************************************************************************";
println ""
final def outProps = new Properties()
outProps.put("tasksIds", tasks)
final def outputPropsFile = new File(args[1])
final def outputPropsStream = null
try {
    outputPropsStream = new FileOutputStream(outputPropsFile)
    outProps.store(outputPropsStream, "")
}
catch (IOException e) {
    throw new RuntimeException(e)
}

if (!badStatus.isEmpty()) {
    println "Not all tasks matched status ${status}"
    badStatus.each { badStat ->
        println "TaskName : " + badStat.getKey()
        println "Status : " + badStat.getValue()
    }
    System.exit(1)
}

println "All task statuses matches requested status, ${status}!"

System.exit(0)