import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.JsonHelper

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

def changeRequestId = props['changeRequestId'];
def status = props['status'];

println "Checking request with number ${changeRequestId}";
println "Checking for status ${status}";
println ""

JsonHelper jsonHelper = new JsonHelper(airTool)
def changeRequestSysId = jsonHelper.getChangeRequestSysId()
def taskList = jsonHelper.getTaskList(changeRequestSysId)

if (taskList.records.size() == 0) {
    println "No tasks were found for Change Request ${changeRequestId}. Exiting failure."
    System.exit(1)
}

def badStatus = [:];
for (def task : taskList.records) {
    println "Checking task " + task.number
    println task.state
    if (Integer.valueOf(task.state) != Integer.valueOf(status)) {
        badStatus.put(task.number, task.state)
    }
    else {
        println "Task " + task.number + " matches status ${status}!";
    }
}

if (!badStatus.isEmpty()) {
    println "Not all tasks matched status ${status}";
    badStatus.each { badStat ->
        println "TaskName : " + badStat.getKey();
        println "Status : " + badStat.getValue();
    }
    System.exit(1);
}

System.exit(0);
