/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import org.apache.http.impl.nio.reactor.BaseIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.nio.params.NIOReactorParams;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public abstract class AbstractMultiworkerIOReactor
implements IOReactor {
    protected volatile IOReactorStatus status;
    protected final HttpParams params;
    protected final Selector selector;
    protected final long selectTimeout;
    private final int workerCount;
    private final ThreadFactory threadFactory;
    private final BaseIOReactor[] dispatchers;
    private final Worker[] workers;
    private final Thread[] threads;
    private final long gracePeriod;
    private final Object shutdownMutex;
    protected IOReactorExceptionHandler exceptionHandler;
    private int currentWorker = 0;

    public AbstractMultiworkerIOReactor(int workerCount, ThreadFactory threadFactory, HttpParams params) throws IOReactorException {
        if (workerCount <= 0) {
            throw new IllegalArgumentException("Worker count may not be negative or zero");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be negative or zero");
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure opening selector", ex);
        }
        this.params = params;
        this.selectTimeout = NIOReactorParams.getSelectInterval(params);
        this.gracePeriod = NIOReactorParams.getGracePeriod(params);
        this.shutdownMutex = new Object();
        this.workerCount = workerCount;
        this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory();
        this.dispatchers = new BaseIOReactor[workerCount];
        this.workers = new Worker[workerCount];
        this.threads = new Thread[workerCount];
        this.status = IOReactorStatus.INACTIVE;
    }

    public IOReactorStatus getStatus() {
        return this.status;
    }

    public void setExceptionHandler(IOReactorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected abstract void processEvents(int var1) throws IOReactorException;

    protected abstract void cancelRequests() throws IOReactorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IOEventDispatch eventDispatch) throws InterruptedIOException, IOReactorException {
        BaseIOReactor dispatcher;
        int i;
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        this.status = IOReactorStatus.ACTIVE;
        for (i = 0; i < this.dispatchers.length; ++i) {
            dispatcher = new BaseIOReactor(this.selectTimeout);
            dispatcher.setExceptionHandler(this.exceptionHandler);
            this.dispatchers[i] = dispatcher;
        }
        for (i = 0; i < this.workerCount; ++i) {
            dispatcher = this.dispatchers[i];
            this.workers[i] = new Worker(dispatcher, eventDispatch);
            this.threads[i] = this.threadFactory.newThread(this.workers[i]);
        }
        for (i = 0; i < this.workerCount; ++i) {
            if (this.status != IOReactorStatus.ACTIVE) {
                return;
            }
            this.threads[i].start();
        }
        try {
            block17: while (true) {
                int readyCount;
                try {
                    readyCount = this.selector.select(this.selectTimeout);
                }
                catch (InterruptedIOException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw new IOReactorException("Unexpected selector failure", ex);
                }
                if (this.status.compareTo(IOReactorStatus.ACTIVE) > 0) {
                    break;
                }
                this.processEvents(readyCount);
                int i2 = 0;
                while (true) {
                    if (i2 >= this.workerCount) continue block17;
                    Worker worker = this.workers[i2];
                    Thread thread = this.threads[i2];
                    if (!thread.isAlive()) {
                        Exception ex = worker.getException();
                        if (ex instanceof IOReactorException) {
                            throw (IOReactorException)ex;
                        }
                        if (ex instanceof InterruptedIOException) {
                            throw (InterruptedIOException)ex;
                        }
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        if (ex != null) {
                            throw new IOReactorException(ex.getMessage(), ex);
                        }
                    }
                    ++i2;
                }
                break;
            }
        }
        catch (ClosedSelectorException ex) {
            try {
                this.doShutdown();
            }
            catch (IOException ex2) {
                throw new IOReactorException(ex2.getMessage(), ex2);
            }
        }
        finally {
            try {
                this.doShutdown();
            }
            catch (IOException ex) {
                throw new IOReactorException(ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShutdown() throws IOException {
        BaseIOReactor dispatcher;
        int i;
        if (this.status.compareTo(IOReactorStatus.SHUTTING_DOWN) >= 0) {
            return;
        }
        this.status = IOReactorStatus.SHUTTING_DOWN;
        this.cancelRequests();
        this.selector.wakeup();
        if (this.selector.isOpen()) {
            Set<SelectionKey> keys = this.selector.keys();
            Iterator<SelectionKey> it = keys.iterator();
            while (it.hasNext()) {
                try {
                    SelectionKey key = it.next();
                    SelectableChannel channel = key.channel();
                    if (channel == null) continue;
                    channel.close();
                }
                catch (IOException iOException) {}
            }
            this.selector.close();
        }
        for (i = 0; i < this.workerCount; ++i) {
            dispatcher = this.dispatchers[i];
            dispatcher.gracefulShutdown();
        }
        try {
            for (i = 0; i < this.workerCount; ++i) {
                dispatcher = this.dispatchers[i];
                if (dispatcher.getStatus() != IOReactorStatus.INACTIVE) {
                    dispatcher.awaitShutdown(this.gracePeriod);
                }
                if (dispatcher.getStatus() == IOReactorStatus.SHUT_DOWN) continue;
                dispatcher.hardShutdown();
            }
            for (i = 0; i < this.workerCount; ++i) {
                Thread t = this.threads[i];
                if (t == null) continue;
                t.join(this.gracePeriod);
            }
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException(ex.getMessage());
        }
        finally {
            Object object = this.shutdownMutex;
            synchronized (object) {
                this.status = IOReactorStatus.SHUT_DOWN;
                this.shutdownMutex.notifyAll();
            }
        }
    }

    protected void addChannel(ChannelEntry entry) {
        this.dispatchers[this.currentWorker++ % this.workerCount].addChannel(entry);
    }

    protected SelectionKey registerChannel(SelectableChannel channel, int ops) throws ClosedChannelException {
        return channel.register(this.selector, ops);
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)this.params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
        int linger = HttpConnectionParams.getLinger((HttpParams)this.params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitShutdown(long timeout) throws InterruptedException {
        Object object = this.shutdownMutex;
        synchronized (object) {
            long deadline = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.status != IOReactorStatus.SHUT_DOWN) {
                this.shutdownMutex.wait(remaining);
                if (timeout <= 0L || (remaining = deadline - System.currentTimeMillis()) > 0L) continue;
            }
        }
    }

    public void shutdown() throws IOException {
        this.shutdown(2000L);
    }

    public void shutdown(long waitMs) throws IOException {
        if (this.status != IOReactorStatus.ACTIVE) {
            return;
        }
        this.status = IOReactorStatus.SHUTDOWN_REQUEST;
        this.selector.wakeup();
        try {
            this.awaitShutdown(waitMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static int COUNT = 0;

        DefaultThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, "I/O dispatcher " + ++COUNT);
        }
    }

    static class Worker
    implements Runnable {
        final BaseIOReactor dispatcher;
        final IOEventDispatch eventDispatch;
        private volatile Exception exception;

        public Worker(BaseIOReactor dispatcher, IOEventDispatch eventDispatch) {
            this.dispatcher = dispatcher;
            this.eventDispatch = eventDispatch;
        }

        public void run() {
            try {
                this.dispatcher.execute(this.eventDispatch);
            }
            catch (InterruptedIOException ex) {
                this.exception = ex;
            }
            catch (IOReactorException ex) {
                this.exception = ex;
            }
            catch (RuntimeException ex) {
                this.exception = ex;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

