/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import java.io.IOException;

public class TypeArgumentsPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new TypeArgumentsPrinter();

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        out.print("<", node.getType());
        boolean first = true;
        AST child = node.getFirstChild();
        while (child != null) {
            this.processTypeArguement(child, out, first);
            first = false;
            child = child.getNextSibling();
        }
        out.print(">", node.getType());
    }

    private void processTypeArguement(AST node, NodeWriter out, boolean first) throws IOException {
        if (node.getType() == 85) {
            PrinterFactory.create(node, out).print(node, out);
        } else {
            AST child = node.getFirstChild();
            while (child != null) {
                switch (child.getType()) {
                    case 64: {
                        out.print("?", child.getType());
                        this.processTypeArguement(child, out, true);
                        break;
                    }
                    case 65: {
                        out.print("extends ", child.getType());
                        this.processTypeArguement(child, out, true);
                        break;
                    }
                    case 66: {
                        out.print("super ", child.getType());
                        this.processTypeArguement(child, out, true);
                        break;
                    }
                    default: {
                        PrinterFactory.create(child, out).print(child, out);
                    }
                }
                child = child.getNextSibling();
            }
        }
    }
}

