/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.JsonHelper

final def airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

def changeRequestId = props['changeRequestId'];
def status = props['status'];

println "Checking request with number ${changeRequestId}";
println "Checking for status ${status}";
println ""

JsonHelper jsonHelper = new JsonHelper(airTool)

def parsedApproval = jsonHelper.getApproval()
if (status.equalsIgnoreCase(parsedApproval)){
    println "Success! Approval status is ${parsedApproval}"
    System.exit(0)
}
else {
    println "Approval status, ${parsedApproval}, is not the specified approval status ${status}. Exiting failure."
    System.exit(1)
}
