/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1

final def airPluginTool = new AirPluginTool(args[0], args[1])
final def props = airPluginTool.getStepProperties()

def changeRequestId = props['changeRequestId']
def status = props['status']

Integer reportedStatus

println "Checking request with number ${changeRequestId}"
println "Checking for Status ${status}"
println ""

HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airPluginTool)
reportedStatus = helper.getStatus()

if (reportedStatus != Integer.valueOf(status)) {
    println "Reported Status, ${reportedStatus} is not equal to ${status}!"
    switch(reportedStatus) {            
        case 1: 
            println("The state of the request is Open"); 
            break; 
        case 2: 
            println("The state of the request is Work-In-Progress"); 
            break; 
        case 3: 
            println("The state of the request is Closed-Complete"); 
            break; 
        case 4: 
            println("The state of the request is Closed-Incomplete"); 
            break;
        case -5: 
            println("The state of the request is Pending"); 
            break;
        case 7: 
            println("The state of the request is Closed-Skipped"); 
            break;
        default: 
            println("The state of the request is Unknown or [not in use]"); 
            break; 
      }
    System.exit(1)
}
else {
    println "Reported Status matches requested Status, ${status}!"
    switch(reportedStatus) {            
        case 1: 
            println("The state of the request is Open"); 
            break; 
        case 2: 
            println("The state of the request is Work-In-Progress"); 
            break; 
        case 3: 
            println("The state of the request is Closed-Complete"); 
            break; 
        case 4: 
            println("The state of the request is Closed-Incomplete"); 
            break;
        case -5: 
            println("The state of the request is Pending"); 
            break;
        case 7: 
            println("The state of the request is Closed-Skipped"); 
            break;
        default: 
            println("The state of the request is Unknown or [not in use]"); 
            break; 
      }
    System.exit(0)
}
