/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1

final def airPluginTool = new AirPluginTool(args[0], args[1])
final def props = airPluginTool.getStepProperties()

println 'ACTION Running encoded query.'
HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airPluginTool)
parsedJson = helper.query()


def sysIDs = parsedJson.result.sys_id
def nLDelimitedTableIDs = StringBuilder.newInstance()
for (sysID in sysIDs) {
    nLDelimitedTableIDs << sysID
    nLDelimitedTableIDs << '\n'
}
airPluginTool.setOutputProperty('recordSystemIDs', nLDelimitedTableIDs.toString())

airPluginTool.setOutputProperties()
