/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1

final def airPluginTool = new AirPluginTool(args[0], args[1])
final def props = airPluginTool.getStepProperties()

def status = props['status'].trim()
def tasksIds = props['tasksId']

println "Updating task Ids with number ${tasksIds}"
println "Updating with status ${status}"
println ""

HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airPluginTool)

tasksIds.split(',').each { taskId ->
    helper.setTaskStatus(taskId.trim(), status)
    println ""
}

println ""
println "All task statuses updated to ${status}!"

System.exit(0)
