/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.servicenow.HelperRestClientJsonV1
import java.text.DateFormat
import java.text.SimpleDateFormat

final def airPluginTool = new AirPluginTool(args[0], args[1])
final def props = airPluginTool.getStepProperties()

def changeRequestId = props['changeRequestId']
String startDateField = props['startDateField'] ?: "start_date"
String endDateField = props['endDateField'] ?: "end_date"
def checkExtensionWindow  = Boolean.valueOf(props['checkExtensionWindow'])

println "Checking request with number ${changeRequestId}"
println "Checking for deployment window"
println ""

def pattern = "yyyy-MM-dd"
DateFormat dateformat = new SimpleDateFormat(pattern)
dateformat.setTimeZone(TimeZone.getTimeZone("UTC"))

HelperRestClientJsonV1 helper = new HelperRestClientJsonV1(airPluginTool)
def deploymentWindow = helper.getDeploymentWindow(startDateField, endDateField)

def currentTime = new Date()

Date newEndDate = dateformat.parse(endDateField)


if(checkExtensionWindow && newEndDate > deploymentWindow[1]) {
    println "[Ok] User has selected Check Extension Window and End date is greater than planned end date"
    System.exit(0)
}
else if (currentTime < deploymentWindow[0]) {
    println "[Error] Current time of ${currentTime} is before change start date ${deploymentWindow[0]}"
    System.exit(1)
}
else if(currentTime > deploymentWindow[1]) {
    println "[Error] Current time of ${currentTime} is past change end date ${deploymentWindow[1]}"
    System.exit(1)
}
else {
    println "[Ok] Current time falls within the start and end date of change request"
    System.exit(0)
}
