/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.CommandHelper

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}
def sharepointUrl = props['sharepointUrl']
def stsadmPath = props['stsadmPath'] ? props['stsadmPath'] : 'stsadm.exe';
def cmpFileName = props['cmpFileName'];
def ch = new CommandHelper(new File('.'));

try {
    args = [];
    args = [stsadmPath, '-o', 'import', '-url', sharepointUrl, '-filename', cmpFileName];
    ch.runCommand(args.join(' '), args);
    }

catch (e) {
    println e
    System.exit 1
}