/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def stsadmPath = props['stsadmPath'] ? props['stsadmPath'] : 'stsadm.exe';
def wspPackageName = props['wspPackageName'];
def allcontenturls = props['allcontenturls'];
def deploymentType = props['deploymentType'];
def time = props['time'];
def sharepointUrl = props['sharepointUrl'];
def allowgacdeployment = Boolean.valueOf(props['allowgacdeployment']);
def allowcaspolicies = Boolean.valueOf(props['allowcaspolicies']);
def force = Boolean.valueOf(props['force']);
def lcid = props['lcid'];
def ch = new CommandHelper(new File('.'))

def Map<String, Boolean> solMap = new HashMap<String, Boolean>();

def enumerate = {
    try {
        println "starting installed package list creation...."
        def process = "$stsadmPath -o enumsolutions".execute()
        def xml = process.text
        def Solutions = new XmlSlurper().parseText(xml)
        def SolutionArray = Solutions.Solution
        SolutionArray.each { Solution ->
            def name = Solution.@Name.text()
            def dep = Boolean.parseBoolean(Solution.Deployed.text())
            solMap.put(name,dep)
            println solMap
        }
        println "installed package list creation complete"
    }
    catch(e){
        println "possible reason for exception no wsp packages are installed"
        println e
    }
}

def install = {
    try {
        println "starting install...."
        def argsImport = [];
        argsImport = [stsadmPath, '-o', 'addsolution', '-filename', wspPackageName];
        ch.runCommand(argsImport.join(' '), argsImport);
        println "install complete"
    }
    catch (e) {
        println e
        System.exit 1
    }
}

def upgrade = {
    try {
        println "starting upgrade...."
        args = [];
        args = [stsadmPath, '-o', 'upgradesolution', '-name', wspPackageName, '-filename', wspPackageName];

        //If Solution is already deployed
        if (solMap.get(wspPackageName.toLowerCase())) {
            if (time){
                args << '-time'
                args << time
            }
            if (deploymentType == 'local' ){
                args << '-local'
            }
            else if (deploymentType == 'immediate'){
                args << '-immediate'
            }
            else if (deploymentType == 'time' &&  time){
                args << '-time'
                args << time
            }
            if (allowgacdeployment){
                args << '-allowgacdeployment'
            }
            if (allowcaspolicies){
                args << '-allowcaspolicies'
            }
            if (lcid){
                args << '-lcid'
                args << lcid
            }
        }
        ch.runCommand(args.join(' '), args);
        println "upgrade complete"
    }
    catch (e) {
        println e
        System.exit 1
    }
}

def deploy = {
    try {
        println "staring deploy...."
        args = [];
        args = [stsadmPath, '-o', 'deploysolution', '-name', wspPackageName];
        if (sharepointUrl) {
            args << '-url'
            args << sharepointUrl
        }
        if (deploymentType == 'local' ){
            args << '-local'
        }
        else if (deploymentType == 'immediate'){
            args << '-immediate'
        }
        else if (deploymentType == 'time' &&  time){
            args << '-time'
            args << time
        }
        if (allowgacdeployment){
            args << '-allowgacdeployment'
        }
        //if (allcontenturls){
        //    args << '-allcontenturls'
        //}
        if (allowcaspolicies){
            args << '-allowcaspolicies'
        }
        if (force) {
            args << '-force'
        }
        if (lcid){
            args << '-lcid'
            args << lcid
        }
        ch.runCommand(args.join(' '), args);
        println "deploy complete"
    }
    catch (e) {
        println e
        System.exit 1
    }
}

enumerate()
// If package not in solMap, install and update solMap
if (!solMap.containsKey(wspPackageName.toLowerCase())) {
    println "install $wspPackageName"
    install()
    // Update solMap
    solMap.put(wspPackageName,false)
}
// If package in solMap and is marked as deployed, upgrade
else if (solMap.get(wspPackageName.toLowerCase())) {
    println "upgrade $wspPackageName"
    upgrade()
}
// If package in solMap but not marked as deployed, deploy
if (!solMap.get(wspPackageName.toLowerCase())) {
    println "deploy package $wspPackageName"
    deploy()
}