/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def powershell = props['powerShellExe']? props['powerShellExe'] : 'PowerShell.exe'
def wspFile = props['wspFile'];
def siteUrl = props['siteUrl'];
def PLUGIN_HOME = System.getenv()['PLUGIN_HOME'];
def ch = new CommandHelper(new File('.'))
def work_Dir = new File(".").getAbsolutePath();
def error = 0


def install = {
	def installArgs = [];
	installArgs = [powershell, PLUGIN_HOME + '\\DeploySandBox.ps1', 'install', work_Dir.substring(0, work_Dir.length()-1) + wspFile, siteUrl];
	ch.runCommand(installArgs.join(' '), installArgs);
}

def activate = {
	def activateArgs = [];
	activateArgs = [powershell, PLUGIN_HOME + '\\DeploySandBox.ps1', 'activate', wspFile, siteUrl];
	ch.runCommand(activateArgs.join(' '), activateArgs);

}

try {
	install()
	activate ()
}
catch (e){
	error = -1
	println e
}

System.exit(error)

