/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.CommandHelper

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}
def stsadmPath = props['stsadmPath'] ? props['stsadmPath'] : 'stsadm.exe';
def filename = props['filename'];
def featureName = props['featureName'];
def id = props['id'];
def sharepointUrl = props['sharepointUrl'];
def force = Boolean.valueOf(props['force']);
def ch = new CommandHelper(new File('.'));

try {
    def args = [];
    args = [stsadmPath, '-o', 'activatefeature']
    if (filename) {
        args << '-filename'
        args << filename
    }
    if (featureName) {
        args << '-name'
        args << featureName
    }
    if (id) {
        args << '-id'
        args << id
    }
    if (sharepointUrl) {
        args << '-url' 
        args << sharepointUrl
    }
    if (force) {
        args << '-force'
    }
    ch.runCommand(args.join(' '), args);
}
catch (e) {
    println e
    System.exit 1
}
    
    