Add-PsSnapin Microsoft.SharePoint.PowerShell

function update{
	Write-Host "Performing update..."
	Update-SPUserSolution -Identity $wspFile -ToSolution $wspFile  -Site $url  -Confirm:$false
}

function activate{
	$Error.Clear()
	Install-SPUserSolution $wspFile -Site $url -Confirm:$false
	if ($Error){
		update
	}	
	
}

function install {
	#To Install 
	Add-SPUserSolution -LiteralPath $wspFile  -Site $url -Confirm:$false
}

Try {
	$action = $args[0]
	write-host "Action = $action"
	$wspFile = $args[1]
	write-host "WSP File = $wspFile "
	$url = $args[2]
	write-host "Url = $url"

	if ($action -eq 'install'){
		install
	}
	elseif ($action -eq 'activate'){
		activate 
	}
	else {
		Write-Host "invalid action"
	}

} 
Catch [system.exception] 
{
	"caught a system exception"
}

