/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

def stsadmPath = props['stsadmPath'] ? props['stsadmPath'] : 'stsadm.exe'
def wspPackageName = props['wspPackageName']
def allcontenturls = Boolean.valueOf(props['allcontenturls'])
def deploymentType = props['deploymentType']
def time = props['time']
def sharepointUrl = props['sharepointUrl']?.trim()
def allowgacdeployment = Boolean.valueOf(props['allowgacdeployment'])
def allowcaspolicies = Boolean.valueOf(props['allowcaspolicies'])
def force = Boolean.valueOf(props['force'])
def lcid = props['lcid']
def fullReinstall= Boolean.valueOf(props['fullreinstall'])
def commandHelper = new CommandHelper(new File('.'))

def Map<String, Boolean> solMap = new HashMap<String, Boolean>()

def enumerate = {
    try {
        println "starting installed package list creation...."
        def process = [stsadmPath, "-o", "enumsolutions"].execute()
        def xml = process.text
        def Solutions = new XmlSlurper().parseText(xml)
        def SolutionArray = Solutions.Solution
        SolutionArray.each { Solution ->
            def name = Solution.@Name.text()
            def isDeployed = Boolean.parseBoolean(Solution.Deployed.text())
            solMap.put(name,isDeployed)
            println solMap
        }
        println "installed package list creation complete"
    }
    catch(e){
        println "possible reason for exception no wsp packages are installed"
        println e
    }
}

def getLastOperationResult = { String name ->
    try {
        def result = null
        def process = [stsadmPath, "-o", "enumsolutions"].execute()
        def xml = process.text
        def Solutions = new XmlSlurper().parseText(xml)
        def SolutionArray = Solutions.Solution
        SolutionArray.each { Solution ->
            if (name.equalsIgnoreCase(Solution.@Name.text())) {
                result =  Solution.LastOperationResult.text()
            }
        }
        return result
    }
    catch(e){
        println "possible reason for exception: package $name not installed"
        println e
    }
}

def waitForPackageLastOperation = { String packageName, String expectedResult, String errorResult, int timeout ->
    isComplete = false
    isSuccess = false
    lastResult = null
    endTime = System.currentTimeMillis() + timeout
    while (!isComplete && System.currentTimeMillis() < endTime) {
        lastResult = getLastOperationResult(wspPackageName)
        if (expectedResult == lastResult) {
            isComplete = true
            isSuccess = true
        }
        else if (errorResult == lastResult) {
            isComplete = true
        }
        else {
            sleep 5000
        }
    }

    if (!isComplete) {
        println "Timed out while waiting for retraction."
        System.exit 1
    }

    if (!isSuccess) {
        println "Last package operation status: $lastResult"
        System.exit 1
    }

}

def install = {
    try {
        println "starting install...."
        def argsImport = [stsadmPath, '-o', 'addsolution', '-filename', wspPackageName]
        commandHelper.runCommand(argsImport.join(' '), argsImport)
        println "install complete"
    }
    catch (e) {
        println e
        System.exit 1
    }
}

def uninstall = {
    try {

        println "starting retract...."
        def argsImport = [stsadmPath, '-o', 'retractsolution', '-name', wspPackageName]
        if (sharepointUrl && sharepointUrl.length() > 0) {
            argsImport << '-url'
            argsImport << sharepointUrl
        }
        if (allcontenturls){
            argsImport << '-allcontenturls'
        }
        if (deploymentType == 'local' ){
            argsImport << '-local'
        }
        else if (deploymentType == 'immediate'){
            argsImport << '-immediate'
        }
        else if (deploymentType == 'time' &&  time){
            argsImport << '-time'
            argsImport << time
        }
        commandHelper.runCommand(argsImport.join(' '), argsImport)
        println "retraction initated"

        println "Waiting for retraction to complete..."
        waitForPackageLastOperation(wspPackageName, 'RetractionSucceeded', 'RetractionFailed', 300000)
        println "retraction complete"

        println "starting remove...."
        argsImport = [stsadmPath, '-o', 'deletesolution', '-name', wspPackageName]
        commandHelper.runCommand(argsImport.join(' '), argsImport)
        println "removal initiated"

        println "Waiting for removal to complete..."
        waitForPackageLastOperation(wspPackageName, null, 'DeletionFailed', 300000)
        println "removal complete"

    }
    catch (e) {
        println e
        System.exit 1
    }
}

def upgrade = {
    try {
        println "starting upgrade...."
        args = []
        args = [stsadmPath, '-o', 'upgradesolution', '-name', wspPackageName, '-filename', wspPackageName]

        //If Solution is already deployed
        if (solMap.get(wspPackageName.toLowerCase())) {
            if (time){
                args << '-time'
                args << time
            }
            if (deploymentType == 'local' ){
                args << '-local'
            }
            else if (deploymentType == 'immediate'){
                args << '-immediate'
            }
            else if (deploymentType == 'time' &&  time){
                args << '-time'
                args << time
            }
            if (allowgacdeployment){
                args << '-allowgacdeployment'
            }
            if (allowcaspolicies){
                args << '-allowcaspolicies'
            }
            if (lcid){
                args << '-lcid'
                args << lcid
            }
        }
        commandHelper.runCommand(args.join(' '), args)
        println "upgrade complete"
    }
    catch (e) {
        println e
        System.exit 1
    }
}

def deploy = {
    try {
        println "staring deploy...."
        args = [stsadmPath, '-o', 'deploysolution', '-name', wspPackageName]
        if (sharepointUrl && sharepointUrl.length() > 0) {
            args << '-url'
            args << sharepointUrl
        }
        if (deploymentType == 'local' ){
            args << '-local'
        }
        else if (deploymentType == 'immediate'){
            args << '-immediate'
        }
        else if (deploymentType == 'time' &&  time){
            args << '-time'
            args << time
        }
        if (allowgacdeployment){
            args << '-allowgacdeployment'
        }
        if (allcontenturls){
            args << '-allcontenturls'
        }
        if (allowcaspolicies){
            args << '-allowcaspolicies'
        }
        if (force) {
            args << '-force'
        }
        if (lcid){
            args << '-lcid'
            args << lcid
        }
        commandHelper.runCommand(args.join(' '), args)
        println "deploy initiated"

        println "waiting for deploy to complete..."
        waitForPackageLastOperation(wspPackageName, 'DeploymentSucceeded', 'DeploymentFailed', 300000)
        println "deployment complete"
    }
    catch (e) {
        println e
        System.exit 1
    }
}

try {
    enumerate()
    // If package not in solMap, install and update solMap
    if (!solMap.containsKey(wspPackageName.toLowerCase())) {
        println "Package $wspPackageName not installed, installing..."
        install()
        // Update solMap
        solMap.put(wspPackageName, false)
    }
    // If package in solMap and is marked as deployed, upgrade
    else if (solMap.get(wspPackageName.toLowerCase())) {
        if (fullReinstall) {
            println "Package $wspPackageName is installed. Full reinstall selected, uninstalling and installing..."
            uninstall()
            solMap.remove(wspPackageName)
            install()
            solMap.put(wspPackageName, false)
        }
        else {
            println "Package $wspPackageName is installed. upgrading..."
            upgrade()
        }
    }
    // If package in solMap but not marked as deployed, deploy
    if (!solMap.get(wspPackageName.toLowerCase())) {
        println "deploy package $wspPackageName"
        deploy()
    }
}
catch (Exception e) {
    e.printStackTrace()
    System.exit 1
}
