/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

def stsadmPath = props['stsadmPath'] ? props['stsadmPath'] : 'stsadm.exe'
def filenameList = props['filename']?.split(",|\n|\r\n")*.trim() as List
def featureNameList = props['featureName']?.split(",|\n|\r\n")*.trim() as List
def idList = props['id']?.split(",|\n|\r\n")*.trim() as List
def sharepointUrlList = props['sharepointUrl']?.split(",|\n|\r\n")*.trim() as List
def force = Boolean.valueOf(props['force']);
def ch = new CommandHelper(new File('.'));

try {
    int featureCount = 0
    boolean hasErrors = false
    if (filenameList != null && filenameList.size() > featureCount) {
        featureCount = filenameList.size()
    }

    if (featureNameList != null && featureNameList.size() > featureCount) {
        featureCount = featureNameList.size()
    }

    if (idList != null && idList.size() > featureCount) {
        featureCount = idList.size()
    }

    println "Detected $featureCount feature(s) to activate."
    for (int i = 0; i < featureCount; i++) {
        args = [stsadmPath, '-o', 'activatefeature']
        if (filenameList != null && filenameList.size() > i && filenameList[i].length() > 0) {
            args << '-filename'
            args << filenameList[i]
        }
        if (featureNameList != null && featureNameList.size() > i && featureNameList[i].length() > 0) {
            args << '-name'
            args << featureNameList[i]
        }
        if (idList != null && idList.size() > i && idList[i].length() > 0) {
            args << '-id'
            args << idList[i]
        }
        if (sharepointUrlList != null && sharepointUrlList.size() > i && sharepointUrlList[i].length() > 0) {
            args << '-url'
            args << sharepointUrlList[i]
        }
        if (force) {
            args << '-force'
        }
        try {
            ch.runCommand(args.join(' '), args);
        }
        catch (Exception e) {
            println e
            hasErrors = true
        }
    }

    if (hasErrors) {
        println "One or more features failed to activate!"
        throw new Exception("One or more features failed to activate!")
    }
}
catch (e) {
    e.printStackTrace()
    System.exit 1
}
