/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.CharSequenceReader;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.SyncFileOutputStream;
import com.urbancode.commons.util.TranscodeOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public final class IO {
    private static final int BUFFER_SIZE = Integer.getInteger("com.urbancode.commons.util.IO.bufferSize", 8192);
    private static final String WINDOWS_INVALID_FILENAME_CHARS = "\\/:*?\"<>|";
    public static final OutputStream NULL = new OutputStream(){

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] buffer) {
            Check.nonNull(buffer, "buffer");
        }

        public void write(byte[] buffer, int offset, int length) {
            Check.nonNull(buffer, "buffer");
            Check.indexRange(buffer.length, offset, length);
        }

        public void write(int byteValue) {
        }
    };
    public static final Writer CNULL = new Writer(){

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] buffer) {
            Check.nonNull(buffer, "buffer");
        }

        public void write(char[] buffer, int offset, int length) {
            Check.nonNull(buffer, "buffer");
            Check.indexRange(buffer.length, offset, length);
        }

        public void write(int byteValue) {
        }

        public void write(String string) {
            Check.nonNull(string, "string");
        }

        public void write(String string, int offset, int length) {
            Check.nonNull(string, "string");
            Check.indexRange(string.length(), offset, length);
        }
    };
    public static final InputStream ZERO = new InputStream(){

        public int available() {
            return Integer.MAX_VALUE;
        }

        public void close() {
        }

        public void mark(int readlimit) {
        }

        public boolean markSupported() {
            return true;
        }

        public int read() {
            return 0;
        }

        public int read(byte[] buffer) {
            Check.nonNull(buffer, "buffer");
            Arrays.fill(buffer, (byte)0);
            return buffer.length;
        }

        public int read(byte[] buffer, int offset, int length) {
            Check.nonNull(buffer, "buffer");
            Check.indexRange(buffer.length, offset, length);
            Arrays.fill(buffer, offset, offset + length, (byte)0);
            return length;
        }

        public void reset() {
        }

        public long skip(long n) {
            return n;
        }
    };

    public static Charset ascii() {
        return AsciiInitializer.ASCII;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedInputStream buffer(InputStream in) {
        BufferedInputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new BufferedInputStream(in);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(in, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedOutputStream buffer(OutputStream out) {
        BufferedOutputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new BufferedOutputStream(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedReader buffer(Reader in) {
        BufferedReader result;
        boolean exceptionInProgress = true;
        try {
            result = new BufferedReader(in);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(in, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedWriter buffer(Writer out) {
        BufferedWriter result;
        boolean exceptionInProgress = true;
        try {
            result = new BufferedWriter(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    public static File build(File base, String ... pathElements) {
        Check.nonNull(base, "base");
        if (pathElements != null) {
            for (String p : pathElements) {
                base = new File(base, p);
            }
        }
        return base;
    }

    public static File build(String ... pathElements) {
        if (pathElements == null || pathElements.length == 0) {
            return IO.pwd();
        }
        String first = pathElements[0];
        File base = new File(first);
        if (!base.isAbsolute()) {
            base = new File(IO.pwd(), first);
        }
        for (int i = 1; i < pathElements.length; ++i) {
            base = new File(base, pathElements[i]);
        }
        return base;
    }

    public static boolean cleanup(List<File> files) {
        boolean exceptionInProgress = true;
        try {
            for (File file : files) {
                try {
                    IO.delete(file);
                }
                catch (Throwable swallow) {}
            }
            exceptionInProgress = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return !exceptionInProgress;
    }

    public static void close(Closeable closeable) {
        IO.closeCloseable(closeable);
    }

    public static void close(DatagramSocket closeable) {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(InputStream closeable) {
        IO.closeCloseable(closeable);
    }

    public static void close(OutputStream closeable) {
        IO.closeCloseable(closeable);
    }

    public static void close(RandomAccessFile closeable) {
        IO.closeCloseable(closeable);
    }

    public static void close(Reader closeable) {
        IO.closeCloseable(closeable);
    }

    public static void close(Writer closeable) {
        IO.closeCloseable(closeable);
    }

    public static void close(ZipFile closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeNoThrow(Closeable closeable) {
        IO.closeNoThrowCloseable(closeable);
    }

    public static void closeNoThrow(DatagramSocket closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void closeNoThrow(InputStream closeable) {
        IO.closeNoThrowCloseable(closeable);
    }

    public static void closeNoThrow(OutputStream closeable) {
        IO.closeNoThrowCloseable(closeable);
    }

    public static void closeNoThrow(RandomAccessFile closeable) {
        IO.closeNoThrowCloseable(closeable);
    }

    public static void closeNoThrow(Reader closeable) {
        IO.closeNoThrowCloseable(closeable);
    }

    public static void closeNoThrow(ServerSocket closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void closeNoThrow(Socket closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void closeNoThrow(Writer closeable) {
        IO.closeNoThrowCloseable(closeable);
    }

    public static void closeNoThrow(ZipFile closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void closeSafely(Closeable closeable, boolean exceptionInProgress) throws IOException {
        if (closeable != null) {
            if (exceptionInProgress) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {}
            } else {
                closeable.close();
            }
        }
    }

    public static void closeSafely(DatagramSocket closeable, boolean exceptionInProgress) {
        if (closeable != null) {
            if (exceptionInProgress) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {}
            } else {
                closeable.close();
            }
        }
    }

    public static void closeSafely(ServerSocket closeable, boolean exceptionInProgress) throws IOException {
        if (closeable != null) {
            if (exceptionInProgress) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {}
            } else {
                closeable.close();
            }
        }
    }

    public static void closeSafely(Socket closeable, boolean exceptionInProgress) throws IOException {
        if (closeable != null) {
            if (exceptionInProgress) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {}
            } else {
                closeable.close();
            }
        }
    }

    public static void closeSafely(ZipFile closeable, boolean exceptionInProgress) throws IOException {
        if (closeable != null) {
            if (exceptionInProgress) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {}
            } else {
                closeable.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dst) throws IOException {
        if (src.equals(dst)) {
            String fmt = "Copy source (%s) and destination (%s) are the same location";
            throw new IllegalArgumentException(String.format(fmt, src, dst));
        }
        if (src.isDirectory()) {
            IO.mkdirs(dst);
            for (File src2 : IO.listFiles(src)) {
                File dst2 = new File(dst, src2.getName());
                IO.copy(src2, dst2);
            }
        } else {
            boolean exceptionInProgress = true;
            FileInputStream in = new FileInputStream(src);
            try {
                IO.copy((InputStream)in, dst);
                exceptionInProgress = false;
            }
            finally {
                IO.closeSafely(in, exceptionInProgress);
            }
        }
    }

    public static void copy(File src, File dst, List<File> newFiles) throws IOException {
        if (src.isDirectory()) {
            IO.mkdirs(dst, newFiles);
            for (File src2 : IO.listFiles(src)) {
                File dst2 = new File(dst, src2.getName());
                IO.copy(src2, dst2, newFiles);
            }
        } else {
            if (dst.createNewFile()) {
                newFiles.add(dst);
            }
            IO.copy(src, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, OutputStream out) throws IOException {
        boolean exceptionInProgress = true;
        FileInputStream in = new FileInputStream(src);
        try {
            IO.copy((InputStream)in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File src, OutputStream out, long count) throws IOException {
        long result;
        boolean exceptionInProgress = true;
        FileInputStream in = new FileInputStream(src);
        try {
            result = IO.copy((InputStream)in, out, count);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, File dst) throws IOException {
        boolean exceptionInProgress = true;
        FileOutputStream out = new FileOutputStream(dst);
        try {
            IO.copy(in, (OutputStream)out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, File dst, long count) throws IOException {
        long result;
        boolean exceptionInProgress = true;
        FileOutputStream out = new FileOutputStream(dst);
        try {
            result = IO.copy(in, (OutputStream)out, count);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
        return result;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[BUFFER_SIZE];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
    }

    public static long copy(InputStream in, OutputStream out, long count) throws IOException {
        int read;
        if (count < 0L) {
            throw new IndexOutOfBoundsException();
        }
        byte[] buffer = new byte[BUFFER_SIZE];
        int length = (int)Math.min(count, (long)buffer.length);
        while (count > 0L && (read = in.read(buffer, 0, length)) != -1) {
            out.write(buffer, 0, read);
            length = (int)Math.min(count -= (long)read, (long)buffer.length);
        }
        return count;
    }

    public static void copy(Reader in, Appendable appendable) throws IOException {
        int count;
        char[] buffer = new char[BUFFER_SIZE];
        CharBuffer charBuffer = CharBuffer.wrap(buffer);
        while ((count = in.read(buffer)) != -1) {
            appendable.append(charBuffer, 0, count);
        }
    }

    public static long copy(Reader in, Appendable appendable, long count) throws IOException {
        int read;
        if (count < 0L) {
            throw new IndexOutOfBoundsException();
        }
        char[] buffer = new char[BUFFER_SIZE];
        CharBuffer charBuffer = CharBuffer.wrap(buffer);
        int length = (int)Math.min(count, (long)buffer.length);
        while (count > 0L && (read = in.read(buffer, 0, length)) != -1) {
            appendable.append(charBuffer, 0, read);
            length = (int)Math.min(count -= (long)read, (long)buffer.length);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader in, File file) throws IOException {
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer(file);
        try {
            IO.copy(in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    public static void copy(Reader in, File file, Charset charset) throws IOException {
        CharsetEncoder encoder = charset.newEncoder();
        IO.copy(in, file, encoder);
    }

    public static long copy(Reader in, File file, Charset charset, long count) throws IOException {
        CharsetEncoder encoder = charset.newEncoder();
        return IO.copy(in, file, encoder, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader in, File file, CharsetEncoder encoder) throws IOException {
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer(file, encoder);
        try {
            IO.copy(in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Reader in, File file, CharsetEncoder encoder, long count) throws IOException {
        long result;
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer(file, encoder);
        try {
            result = IO.copy(in, out, count);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Reader in, File file, long count) throws IOException {
        long result;
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer(file);
        try {
            result = IO.copy(in, out, count);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
        return result;
    }

    public static void copy(Reader in, File file, String charsetName) throws IOException {
        Charset charset = Charset.forName(charsetName);
        IO.copy(in, file, charset);
    }

    public static long copy(Reader in, File file, String charsetName, long count) throws IOException {
        Charset charset = Charset.forName(charsetName);
        return IO.copy(in, file, charset, count);
    }

    public static void copy(Reader in, Writer out) throws IOException {
        int count;
        char[] buffer = new char[BUFFER_SIZE];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
    }

    public static long copy(Reader in, Writer out, long count) throws IOException {
        int read;
        if (count < 0L) {
            throw new IndexOutOfBoundsException();
        }
        char[] buffer = new char[BUFFER_SIZE];
        int length = (int)Math.min(count, (long)buffer.length);
        while (count > 0L && (read = in.read(buffer, 0, length)) != -1) {
            out.write(buffer, 0, read);
            length = (int)Math.min(count -= (long)read, (long)buffer.length);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndDigest(File src, OutputStream out, MessageDigest ... digesters) throws IOException {
        if (digesters == null || digesters.length == 0) {
            IO.copy(src, out);
        } else {
            boolean exceptionInProgress = true;
            FileInputStream in = new FileInputStream(src);
            try {
                IO.copyAndDigest((InputStream)in, out, digesters);
                exceptionInProgress = false;
            }
            finally {
                IO.closeSafely(in, exceptionInProgress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyAndDigest(InputStream in, File dst, long count, MessageDigest ... digesters) throws IOException {
        long result;
        if (digesters == null || digesters.length == 0) {
            result = IO.copy(in, dst, count);
        } else {
            boolean exceptionInProgress = true;
            FileOutputStream out = new FileOutputStream(dst);
            try {
                result = IO.copyAndDigest(in, (OutputStream)out, count, digesters);
                exceptionInProgress = false;
            }
            finally {
                IO.closeSafely(out, exceptionInProgress);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndDigest(InputStream in, File dst, MessageDigest ... digesters) throws IOException {
        if (digesters == null || digesters.length == 0) {
            IO.copy(in, dst);
        } else {
            boolean exceptionInProgress = true;
            FileOutputStream out = new FileOutputStream(dst);
            try {
                IO.copyAndDigest(in, (OutputStream)out, digesters);
                exceptionInProgress = false;
            }
            finally {
                IO.closeSafely(out, exceptionInProgress);
            }
        }
    }

    public static long copyAndDigest(InputStream in, OutputStream out, long count, MessageDigest ... digesters) throws IOException {
        long result;
        if (digesters == null || digesters.length == 0) {
            result = IO.copy(in, out, count);
        } else {
            int read;
            byte[] buffer = new byte[BUFFER_SIZE];
            int length = (int)Math.min(count, (long)buffer.length);
            while (count > 0L && (read = in.read(buffer, 0, length)) != -1) {
                for (MessageDigest digester : digesters) {
                    digester.update(buffer, 0, read);
                }
                out.write(buffer, 0, read);
                length = (int)Math.min(count -= (long)read, (long)buffer.length);
            }
            result = count;
        }
        return result;
    }

    public static void copyAndDigest(InputStream in, OutputStream out, MessageDigest ... digesters) throws IOException {
        if (digesters == null || digesters.length == 0) {
            IO.copy(in, out);
        } else {
            int count;
            byte[] buffer = new byte[BUFFER_SIZE];
            while ((count = in.read(buffer)) != -1) {
                for (MessageDigest digester : digesters) {
                    digester.update(buffer, 0, count);
                }
                out.write(buffer, 0, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyAndDigestSync(InputStream in, File dst, long count, MessageDigest ... digesters) throws IOException {
        long result;
        if (digesters == null || digesters.length == 0) {
            result = IO.copySync(in, dst, count);
        } else {
            boolean exceptionInProgress = true;
            SyncFileOutputStream out = new SyncFileOutputStream(dst);
            try {
                result = IO.copyAndDigest(in, (OutputStream)out, count, digesters);
                exceptionInProgress = false;
            }
            finally {
                IO.closeSafely(out, exceptionInProgress);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndDigestSync(InputStream in, File dst, MessageDigest ... digesters) throws IOException {
        if (digesters == null || digesters.length == 0) {
            IO.copySync(in, dst);
        } else {
            boolean exceptionInProgress = true;
            SyncFileOutputStream out = new SyncFileOutputStream(dst);
            try {
                IO.copyAndDigest(in, (OutputStream)out, digesters);
                exceptionInProgress = false;
            }
            finally {
                IO.closeSafely(out, exceptionInProgress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAppend(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            IO.mkdirs(dst);
            for (File src2 : IO.listFiles(src)) {
                File dst2 = new File(dst, src2.getName());
                IO.copy(src2, dst2);
            }
        } else {
            boolean exceptionInProgress = true;
            FileInputStream in = new FileInputStream(src);
            try {
                IO.copyAppend(in, dst);
                exceptionInProgress = false;
            }
            finally {
                IO.closeSafely(in, exceptionInProgress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAppend(InputStream in, File dst) throws IOException {
        boolean exceptionInProgress = true;
        FileOutputStream out = new FileOutputStream(dst, true);
        try {
            IO.copy(in, (OutputStream)out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySync(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            IO.mkdirs(dst);
            for (File src2 : IO.listFiles(src)) {
                File dst2 = new File(dst, src2.getName());
                IO.copySync(src2, dst2);
            }
        } else {
            boolean exceptionInProgress = true;
            FileInputStream in = new FileInputStream(src);
            try {
                IO.copySync(in, dst);
                exceptionInProgress = false;
            }
            finally {
                IO.closeSafely(in, exceptionInProgress);
            }
        }
    }

    public static void copySync(File src, File dst, List<File> newFiles) throws IOException {
        if (src.isDirectory()) {
            IO.mkdirs(dst, newFiles);
            for (File src2 : IO.listFiles(src)) {
                File dst2 = new File(dst, src2.getName());
                IO.copySync(src2, dst2, newFiles);
            }
        } else {
            if (dst.createNewFile()) {
                newFiles.add(dst);
            }
            IO.copySync(src, dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySync(InputStream in, File dst) throws IOException {
        boolean exceptionInProgress = true;
        SyncFileOutputStream out = new SyncFileOutputStream(dst);
        try {
            IO.copy(in, (OutputStream)out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copySync(InputStream in, File dst, long count) throws IOException {
        long result;
        boolean exceptionInProgress = true;
        SyncFileOutputStream out = new SyncFileOutputStream(dst);
        try {
            result = IO.copy(in, (OutputStream)out, count);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySync(Reader in, File file) throws IOException {
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer(new SyncFileOutputStream(file));
        try {
            IO.copy(in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    public static void copySync(Reader in, File file, Charset charset) throws IOException {
        CharsetEncoder encoder = charset.newEncoder();
        IO.copySync(in, file, encoder);
    }

    public static long copySync(Reader in, File file, Charset charset, long count) throws IOException {
        CharsetEncoder encoder = charset.newEncoder();
        return IO.copySync(in, file, encoder, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySync(Reader in, File file, CharsetEncoder encoder) throws IOException {
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer((OutputStream)new SyncFileOutputStream(file), encoder);
        try {
            IO.copy(in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copySync(Reader in, File file, CharsetEncoder encoder, long count) throws IOException {
        long result;
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer((OutputStream)new SyncFileOutputStream(file), encoder);
        try {
            result = IO.copy(in, out, count);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copySync(Reader in, File file, long count) throws IOException {
        long result;
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer(new SyncFileOutputStream(file));
        try {
            result = IO.copy(in, out, count);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
        return result;
    }

    public static void copySync(Reader in, File file, String charsetName) throws IOException {
        Charset charset = Charset.forName(charsetName);
        IO.copySync(in, file, charset);
    }

    public static long copySync(Reader in, File file, String charsetName, long count) throws IOException {
        Charset charset = Charset.forName(charsetName);
        return IO.copySync(in, file, charset, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataInputStream data(InputStream in) {
        DataInputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new DataInputStream(in);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(in, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataOutputStream data(OutputStream out) {
        DataOutputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new DataOutputStream(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    public static String decode(Charset cs, byte[] bb) {
        return cs.decode(ByteBuffer.wrap(bb)).toString();
    }

    public static String decode(Charset cs, byte[] b, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.position(offset);
        bb.limit(offset + length);
        return cs.decode(bb).toString();
    }

    public static void delete(Collection<File> files) throws IOException {
        IO.delete(files);
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            for (File f : IO.listFiles(file)) {
                IO.delete(f);
            }
        }
        IO.deleteNonRecursive(file);
    }

    public static void delete(Iterable<File> files) throws IOException {
        for (File file : files) {
            IO.delete(file);
        }
    }

    public static void delete(List<File> files) throws IOException {
        IO.delete(files);
    }

    public static void deleteNonRecursive(Collection<File> files) throws IOException {
        IO.deleteNonRecursive(files);
    }

    public static void deleteNonRecursive(File file) throws IOException {
        if (!file.delete() && file.exists()) {
            throw new IOException("Unable to delete " + file.getAbsolutePath());
        }
    }

    public static void deleteNonRecursive(Iterable<File> files) throws IOException {
        for (File file : files) {
            IO.deleteNonRecursive(file);
        }
    }

    public static Object deserialize(byte[] array) throws IOException {
        Object result;
        ByteArrayInputStream ain = new ByteArrayInputStream(array);
        ObjectInputStream in = new ObjectInputStream(ain);
        try {
            result = in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void digest(File file, MessageDigest digester) throws IOException {
        boolean exceptionInProgress = true;
        DigestInputStream in = IO.digest(new FileInputStream(file), digester);
        try {
            IO.copy((InputStream)in, NULL);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DigestInputStream digest(InputStream in, MessageDigest digester) {
        DigestInputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new DigestInputStream(in, digester);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(in, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DigestOutputStream digest(OutputStream out, MessageDigest digester) {
        DigestOutputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new DigestOutputStream(out, digester);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void digestNow(InputStream in, MessageDigest digester) throws IOException {
        boolean exceptionInProgress = true;
        DigestInputStream din = IO.digest(in, digester);
        try {
            IO.copy((InputStream)din, NULL);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(din, exceptionInProgress);
        }
    }

    public static void discard(InputStream in) throws IOException {
        IO.copy(in, NULL);
    }

    public static boolean discard(InputStream in, long count) throws IOException {
        return IO.copy(in, NULL, count) != 0L;
    }

    public static byte[] encode(Charset cs, String s) {
        ByteBuffer bb = cs.encode(s);
        byte[] result = new byte[bb.limit()];
        bb.get(result);
        return result;
    }

    public static Charset latin1() {
        return Latin1Initializer.LATIN1;
    }

    public static InputStream limited(InputStream in, long limit) {
        Check.nonNegative(limit, "limit");
        Check.nonNull(in, "in");
        return new LimitedInputStream(limit, in);
    }

    @Deprecated
    public static List<File> list(File file) {
        return IO.listFilesRecursive(file);
    }

    @Deprecated
    public static void list(File file, List<File> result) {
        IO.listFilesRecursive(file, result);
    }

    public static List<File> listFiles(File directory) {
        List<File> result = Collections.emptyList();
        File[] files = directory.listFiles();
        if (files != null) {
            result = Collections.unmodifiableList(Arrays.asList(files));
        }
        return result;
    }

    public static List<File> listFilesEx(File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            if (directory.isDirectory()) {
                throw new IOException("Access denied: " + directory.getAbsolutePath());
            }
            throw new IOException("Not a directory: " + directory.getAbsolutePath());
        }
        return Collections.unmodifiableList(Arrays.asList(files));
    }

    public static List<File> listFilesRecursive(File file) {
        ArrayList<File> result = new ArrayList<File>();
        IO.listFilesRecursive(file, result);
        return Collections.unmodifiableList(result);
    }

    public static void listFilesRecursive(File file, List<File> result) {
        if (file.isFile()) {
            result.add(file);
        } else {
            for (File f : IO.listFiles(file)) {
                IO.listFilesRecursive(f, result);
            }
        }
    }

    public static MessageDigest md2Digester() {
        MessageDigest result;
        try {
            result = MessageDigest.getInstance("MD2");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Standard algorithm MD2 unavailable", e);
        }
        return result;
    }

    public static MessageDigest md5Digester() {
        MessageDigest result;
        try {
            result = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Standard algorithm MD5 unavailable", e);
        }
        return result;
    }

    public static void mergeDirectories(File source, File destination) throws IOException {
        Check.nonNull(source, "source path");
        Check.nonNull(destination, "destination path");
        if (!source.exists()) {
            throw new IllegalArgumentException("Source path for moving '" + source.getPath() + "' does not exist.");
        }
        if (source.isDirectory() && destination.isDirectory()) {
            for (File src2 : IO.listFiles(source)) {
                File dst2 = new File(destination, src2.getName());
                IO.mergeDirectories(src2, dst2);
            }
            IO.deleteNonRecursive(source);
        } else {
            IO.move(source, destination);
        }
    }

    public static boolean mkdirs(File dir) throws IOException {
        return IO.mkdirs(dir, null);
    }

    public static boolean mkdirs(File dir, List<File> newFiles) throws IOException {
        boolean created;
        if (dir.exists()) {
            created = false;
        } else if (IO.mkdir0(dir)) {
            created = true;
            if (newFiles != null) {
                newFiles.add(dir);
            }
        } else {
            File canonFile = dir.getCanonicalFile();
            File parent = canonFile.getParentFile();
            if (parent != null) {
                created = IO.mkdirs0(parent, dir, newFiles);
                if (created && (created = canonFile.mkdir()) && newFiles != null) {
                    newFiles.add(dir);
                }
            } else {
                created = false;
            }
        }
        IO.checkForDirectory(created, dir, dir);
        return created;
    }

    public static void move(File source, File destination) throws IOException {
        File tempDestination;
        boolean renamed = source.renameTo(destination);
        if (!renamed && destination.exists() && (renamed = destination.renameTo(tempDestination = new File(destination.getParentFile(), UUID.randomUUID().toString())))) {
            renamed = source.renameTo(destination);
            if (renamed) {
                try {
                    IO.delete(tempDestination);
                }
                catch (IOException e) {
                    String message = "Failed to remove temporary destination file " + tempDestination + " after move";
                    if (e.getMessage() != null) {
                        message = message + ": " + e.getMessage();
                    }
                    throw (IOException)new IOException(message).initCause(e);
                }
            } else if (!tempDestination.renameTo(destination)) {
                throw new IOException("Failed to restore " + tempDestination + " to " + destination);
            }
        }
        if (!renamed) {
            try {
                IO.copySync(source, destination);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                String message = "Failed during copy of " + source + " to " + destination;
                if (e.getMessage() != null) {
                    message = message + ": " + e.getMessage();
                }
                throw (IOException)new IOException(message).initCause(e);
            }
            try {
                IO.delete(source);
            }
            catch (IOException e) {
                String message = "Unable to remove source file " + source;
                if (e.getMessage() != null) {
                    message = message + ": " + e.getMessage();
                }
                throw (IOException)new IOException(message).initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream multiplex(OutputStream first, OutputStream ... rest) {
        MultiplexOutputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new MultiplexOutputStream(first, rest);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(first, exceptionInProgress);
            if (exceptionInProgress && rest != null) {
                for (OutputStream stream : rest) {
                    IO.closeNoThrow(stream);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream noClose(OutputStream out) {
        NoCloseOutputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new NoCloseOutputStream(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintStream noClose(PrintStream out) {
        NoClosePrintStream result;
        boolean exceptionInProgress = true;
        try {
            result = new NoClosePrintStream(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintWriter noClose(PrintWriter out) {
        NoClosePrintWriter result;
        boolean exceptionInProgress = true;
        try {
            result = new NoClosePrintWriter(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writer noClose(Writer out) {
        NoCloseWriter result;
        boolean exceptionInProgress = true;
        try {
            result = new NoCloseWriter(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineNumberReader number(Reader in) {
        LineNumberReader result;
        boolean exceptionInProgress = true;
        try {
            result = new LineNumberReader(in);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(in, exceptionInProgress);
        }
        return result;
    }

    public static BufferedOutputStream openAppend(File file) throws FileNotFoundException {
        return IO.buffer(new FileOutputStream(file, true));
    }

    public static BufferedOutputStream openAppend(String path) throws FileNotFoundException {
        return IO.openAppend(new File(path));
    }

    public static BufferedOutputStream openAppendSync(File file) throws FileNotFoundException {
        return IO.buffer(new SyncFileOutputStream(file, true));
    }

    public static BufferedOutputStream openAppendSync(String path) throws FileNotFoundException {
        return IO.openAppendSync(new File(path));
    }

    public static BufferedWriter openAppendText(File file) throws FileNotFoundException {
        return IO.buffer(IO.writer(new FileOutputStream(file, true)));
    }

    public static BufferedWriter openAppendText(File file, Charset charset) throws FileNotFoundException {
        return IO.buffer(IO.writer((OutputStream)new FileOutputStream(file, true), charset));
    }

    public static BufferedWriter openAppendText(File file, CharsetEncoder encoder) throws FileNotFoundException {
        return IO.buffer(IO.writer((OutputStream)new FileOutputStream(file, true), encoder));
    }

    public static BufferedWriter openAppendText(File file, String charsetName) throws FileNotFoundException {
        return IO.buffer(IO.writer((OutputStream)new FileOutputStream(file, true), charsetName));
    }

    public static BufferedWriter openAppendText(String path) throws FileNotFoundException {
        return IO.openAppendText(new File(path));
    }

    public static BufferedWriter openAppendText(String path, Charset charset) throws FileNotFoundException {
        return IO.openAppendText(new File(path), charset);
    }

    public static BufferedWriter openAppendText(String path, CharsetEncoder encoder) throws FileNotFoundException {
        return IO.openAppendText(new File(path), encoder);
    }

    public static BufferedWriter openAppendText(String path, String charsetName) throws FileNotFoundException {
        return IO.openAppendText(new File(path), charsetName);
    }

    public static BufferedWriter openAppendTextSync(File file) throws FileNotFoundException {
        return IO.buffer(IO.writer(new SyncFileOutputStream(file, true)));
    }

    public static BufferedWriter openAppendTextSync(File file, Charset charset) throws FileNotFoundException {
        return IO.buffer(IO.writer((OutputStream)new SyncFileOutputStream(file, true), charset));
    }

    public static BufferedWriter openAppendTextSync(File file, CharsetEncoder encoder) throws FileNotFoundException {
        return IO.buffer(IO.writer((OutputStream)new SyncFileOutputStream(file, true), encoder));
    }

    public static BufferedWriter openAppendTextSync(File file, String charsetName) throws FileNotFoundException {
        return IO.buffer(IO.writer((OutputStream)new SyncFileOutputStream(file, true), charsetName));
    }

    public static BufferedWriter openAppendTextSync(String path) throws FileNotFoundException {
        return IO.openAppendTextSync(new File(path));
    }

    public static BufferedWriter openAppendTextSync(String path, Charset charset) throws FileNotFoundException {
        return IO.openAppendTextSync(new File(path), charset);
    }

    public static BufferedWriter openAppendTextSync(String path, CharsetEncoder encoder) throws FileNotFoundException {
        return IO.openAppendTextSync(new File(path), encoder);
    }

    public static BufferedWriter openAppendTextSync(String path, String charsetName) throws FileNotFoundException {
        return IO.openAppendTextSync(new File(path), charsetName);
    }

    public static BufferedInputStream openInput(File file) throws FileNotFoundException {
        return IO.buffer(new FileInputStream(file));
    }

    public static BufferedInputStream openInput(String path) throws FileNotFoundException {
        return IO.openInput(new File(path));
    }

    public static BufferedReader openInputText(File file) throws FileNotFoundException {
        return IO.buffer(IO.reader(file));
    }

    public static BufferedReader openInputText(File file, Charset charset) throws FileNotFoundException {
        return IO.buffer(IO.reader(file, charset));
    }

    public static BufferedReader openInputText(File file, CharsetDecoder decoder) throws FileNotFoundException {
        return IO.buffer(IO.reader(file, decoder));
    }

    public static BufferedReader openInputText(File file, String charsetName) throws FileNotFoundException {
        return IO.buffer(IO.reader(file, charsetName));
    }

    public static BufferedReader openInputText(String fileName) throws FileNotFoundException {
        return IO.buffer(IO.reader(new File(fileName)));
    }

    public static BufferedReader openInputText(String fileName, Charset charset) throws FileNotFoundException {
        return IO.buffer(IO.reader(new File(fileName), charset));
    }

    public static BufferedReader openInputText(String fileName, CharsetDecoder decoder) throws FileNotFoundException {
        return IO.buffer(IO.reader(new File(fileName), decoder));
    }

    public static BufferedReader openInputText(String fileName, String charsetName) throws FileNotFoundException {
        return IO.buffer(IO.reader(new File(fileName), charsetName));
    }

    public static ZipInputStream openInputZip(File file) throws FileNotFoundException {
        return IO.zip(new FileInputStream(file));
    }

    public static ZipInputStream openInputZip(String path) throws FileNotFoundException {
        return IO.openInputZip(new File(path));
    }

    public static BufferedOutputStream openOutput(File file) throws FileNotFoundException {
        return IO.buffer(new FileOutputStream(file));
    }

    public static BufferedOutputStream openOutput(String path) throws FileNotFoundException {
        return IO.openOutput(new File(path));
    }

    public static BufferedOutputStream openOutputSync(File file) throws FileNotFoundException {
        return IO.buffer(new SyncFileOutputStream(file));
    }

    public static BufferedOutputStream openOutputSync(String path) throws FileNotFoundException {
        return IO.openOutputSync(new File(path));
    }

    public static BufferedWriter openOutputText(File file) throws FileNotFoundException {
        return IO.buffer(IO.writer(file));
    }

    public static BufferedWriter openOutputText(File file, Charset charset) throws FileNotFoundException {
        return IO.buffer(IO.writer(file, charset));
    }

    public static BufferedWriter openOutputText(File file, CharsetEncoder encoder) throws FileNotFoundException {
        return IO.buffer(IO.writer(file, encoder));
    }

    public static BufferedWriter openOutputText(File file, String charsetName) throws FileNotFoundException {
        return IO.buffer(IO.writer(file, charsetName));
    }

    public static BufferedWriter openOutputText(String path) throws FileNotFoundException {
        return IO.openOutputText(new File(path));
    }

    public static BufferedWriter openOutputText(String path, Charset charset) throws FileNotFoundException {
        return IO.openOutputText(new File(path), charset);
    }

    public static BufferedWriter openOutputText(String path, CharsetEncoder encoder) throws FileNotFoundException {
        return IO.openOutputText(new File(path), encoder);
    }

    public static BufferedWriter openOutputText(String path, String charsetName) throws FileNotFoundException {
        return IO.openOutputText(new File(path), charsetName);
    }

    public static BufferedWriter openOutputTextSync(File file) throws FileNotFoundException {
        return IO.buffer(IO.writer(new SyncFileOutputStream(file)));
    }

    public static BufferedWriter openOutputTextSync(File file, Charset charset) throws FileNotFoundException {
        return IO.buffer(IO.writer((OutputStream)new SyncFileOutputStream(file), charset));
    }

    public static BufferedWriter openOutputTextSync(File file, CharsetEncoder encoder) throws FileNotFoundException {
        return IO.buffer(IO.writer((OutputStream)new SyncFileOutputStream(file), encoder));
    }

    public static BufferedWriter openOutputTextSync(File file, String charsetName) throws FileNotFoundException {
        return IO.buffer(IO.writer((OutputStream)new SyncFileOutputStream(file), charsetName));
    }

    public static BufferedWriter openOutputTextSync(String path) throws FileNotFoundException {
        return IO.openOutputTextSync(new File(path));
    }

    public static BufferedWriter openOutputTextSync(String path, Charset charset) throws FileNotFoundException {
        return IO.openOutputTextSync(new File(path), charset);
    }

    public static BufferedWriter openOutputTextSync(String path, CharsetEncoder encoder) throws FileNotFoundException {
        return IO.openOutputTextSync(new File(path), encoder);
    }

    public static BufferedWriter openOutputTextSync(String path, String charsetName) throws FileNotFoundException {
        return IO.openOutputTextSync(new File(path), charsetName);
    }

    public static ZipOutputStream openOutputZip(File file) throws FileNotFoundException {
        return IO.zip(new FileOutputStream(file));
    }

    public static ZipOutputStream openOutputZip(String path) throws FileNotFoundException {
        return IO.openOutputZip(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintStream printer(OutputStream out) {
        PrintStream result;
        boolean exceptionInProgress = true;
        try {
            result = new PrintStream(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintStream printer(OutputStream out, boolean autoflush) {
        PrintStream result;
        boolean exceptionInProgress = true;
        try {
            result = new PrintStream(out, autoflush);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintWriter printer(Writer out) {
        PrintWriter result;
        boolean exceptionInProgress = true;
        try {
            result = new PrintWriter(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintWriter printer(Writer out, boolean autoflush) {
        PrintWriter result;
        boolean exceptionInProgress = true;
        try {
            result = new PrintWriter(out, autoflush);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    public static File pwd() {
        return PwdInitializer.pwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream out;
        boolean exceptionInProgress = true;
        try {
            out = new ByteArrayOutputStream();
            IO.copy(in, (OutputStream)out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
        return out.toByteArray();
    }

    public static char readChar(InputStream in) throws IOException {
        return IO.readChar(in, ByteOrder.BIG_ENDIAN);
    }

    public static char readChar(InputStream in, ByteOrder order) throws IOException {
        return (char)IO.readShort(in, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readChars(Reader in) throws IOException {
        CharArrayWriter out;
        boolean exceptionInProgress = true;
        try {
            out = new CharArrayWriter();
            IO.copy(in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
        return out.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readCharsFile(File file) throws IOException {
        CharArrayWriter out;
        boolean exceptionInProgress = true;
        InputStreamReader in = IO.reader(file);
        try {
            out = new CharArrayWriter();
            IO.copy((Reader)in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
        return out.toCharArray();
    }

    public static char[] readCharsFile(File file, Charset charset) throws IOException {
        CharsetDecoder decoder = charset.newDecoder();
        return IO.readCharsFile(file, decoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readCharsFile(File file, CharsetDecoder decoder) throws IOException {
        CharArrayWriter out;
        boolean exceptionInProgress = true;
        InputStreamReader in = IO.reader(file, decoder);
        try {
            out = new CharArrayWriter();
            IO.copy((Reader)in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
        return out.toCharArray();
    }

    public static double readDouble(InputStream in) throws IOException {
        return IO.readDouble(in, ByteOrder.BIG_ENDIAN);
    }

    public static double readDouble(InputStream in, ByteOrder order) throws IOException {
        long d = IO.readLong(in, order);
        return Double.longBitsToDouble(d);
    }

    public static Reader reader(char[] array) {
        CharBuffer buffer = CharBuffer.wrap(array);
        return IO.reader(buffer);
    }

    public static Reader reader(CharSequence sequence) {
        return new CharSequenceReader(sequence);
    }

    public static InputStreamReader reader(File file) throws FileNotFoundException {
        return IO.reader(new FileInputStream(file));
    }

    public static InputStreamReader reader(File file, Charset charset) throws FileNotFoundException {
        return IO.reader((InputStream)new FileInputStream(file), charset);
    }

    public static InputStreamReader reader(File file, CharsetDecoder decoder) throws FileNotFoundException {
        return IO.reader((InputStream)new FileInputStream(file), decoder);
    }

    public static InputStreamReader reader(File file, String charsetName) throws FileNotFoundException {
        return IO.reader((InputStream)new FileInputStream(file), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStreamReader reader(InputStream in) {
        InputStreamReader result;
        boolean exceptionInProgress = true;
        try {
            result = new InputStreamReader(in);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(in, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStreamReader reader(InputStream in, Charset charset) {
        InputStreamReader result;
        if (charset == null) {
            result = IO.reader(in);
        } else {
            CharsetDecoder decoder;
            boolean exceptionInProgress = true;
            try {
                decoder = charset.newDecoder();
                exceptionInProgress = false;
            }
            finally {
                IO.closeOnException(in, exceptionInProgress);
            }
            result = IO.reader(in, decoder);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStreamReader reader(InputStream in, CharsetDecoder decoder) {
        InputStreamReader result;
        if (decoder == null) {
            result = IO.reader(in);
        } else {
            boolean exceptionInProgress = true;
            try {
                result = new InputStreamReader(in, decoder);
                exceptionInProgress = false;
            }
            finally {
                IO.closeOnException(in, exceptionInProgress);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStreamReader reader(InputStream in, String charsetName) {
        InputStreamReader result;
        if (charsetName == null) {
            result = IO.reader(in);
        } else {
            boolean exceptionInProgress = true;
            try {
                result = new InputStreamReader(in, Charset.forName(charsetName));
                exceptionInProgress = false;
            }
            finally {
                IO.closeOnException(in, exceptionInProgress);
            }
        }
        return result;
    }

    public static StringReader reader(String string) {
        return new StringReader(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) throws IOException {
        ByteArrayOutputStream out;
        boolean exceptionInProgress = true;
        FileInputStream in = new FileInputStream(file);
        try {
            out = new ByteArrayOutputStream();
            IO.copy((InputStream)in, (OutputStream)out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
        return out.toByteArray();
    }

    public static float readFloat(InputStream in) throws IOException {
        return IO.readFloat(in, ByteOrder.BIG_ENDIAN);
    }

    public static float readFloat(InputStream in, ByteOrder order) throws IOException {
        int d = IO.readInt(in, order);
        return Float.intBitsToFloat(d);
    }

    public static int readFully(InputStream in, byte[] buffer) throws IOException {
        return IO.readFully(in, buffer, 0, buffer.length);
    }

    public static int readFully(InputStream in, byte[] buffer, int offset, int length) throws IOException {
        int read = 0;
        while (length > 0 && (read = in.read(buffer, offset, length)) != -1) {
            offset += read;
            length -= read;
        }
        return length;
    }

    public static int readFully(Reader in, char[] buffer) throws IOException {
        return IO.readFully(in, buffer, 0, buffer.length);
    }

    public static int readFully(Reader in, char[] buffer, int offset, int length) throws IOException {
        int read = 0;
        while (length > 0 && (read = in.read(buffer, offset, length)) != -1) {
            offset += read;
            length -= read;
        }
        return length;
    }

    public static int readInt(InputStream in) throws IOException {
        return IO.readInt(in, ByteOrder.BIG_ENDIAN);
    }

    public static int readInt(InputStream in, ByteOrder order) throws IOException {
        byte[] buffer = new byte[4];
        if (IO.readFully(in, buffer) != 0) {
            throw new EOFException();
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(order);
        return bb.getInt();
    }

    public static long readLong(InputStream in) throws IOException {
        return IO.readLong(in, ByteOrder.BIG_ENDIAN);
    }

    public static long readLong(InputStream in, ByteOrder order) throws IOException {
        byte[] buffer = new byte[8];
        if (IO.readFully(in, buffer) != 0) {
            throw new EOFException();
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(order);
        return bb.getLong();
    }

    public static short readShort(InputStream in) throws IOException {
        return IO.readShort(in, ByteOrder.BIG_ENDIAN);
    }

    public static short readShort(InputStream in, ByteOrder order) throws IOException {
        byte[] buffer = new byte[2];
        if (IO.readFully(in, buffer) != 0) {
            throw new EOFException();
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(order);
        return bb.getShort();
    }

    public static String readText(InputStream in) throws IOException {
        return IO.readText(IO.reader(in));
    }

    public static String readText(InputStream in, Charset charset) throws IOException {
        return IO.readText(IO.reader(in, charset));
    }

    public static String readText(InputStream in, CharsetDecoder decoder) throws IOException {
        return IO.readText(IO.reader(in, decoder));
    }

    public static String readText(InputStream in, String charsetName) throws IOException {
        return IO.readText(IO.reader(in, charsetName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(Reader in) throws IOException {
        boolean exceptionInProgress = true;
        StringBuilder builder = new StringBuilder();
        try {
            IO.copy(in, builder);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) throws IOException {
        StringWriter out;
        boolean exceptionInProgress = true;
        InputStreamReader in = IO.reader(file);
        try {
            out = new StringWriter();
            IO.copy((Reader)in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
        return ((Object)out).toString();
    }

    public static String readTextFile(File file, Charset charset) throws IOException {
        CharsetDecoder decoder = charset.newDecoder();
        return IO.readTextFile(file, decoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file, CharsetDecoder decoder) throws IOException {
        StringWriter out;
        boolean exceptionInProgress = true;
        InputStreamReader in = IO.reader(file, decoder);
        try {
            out = new StringWriter();
            IO.copy((Reader)in, out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(in, exceptionInProgress);
        }
        return ((Object)out).toString();
    }

    public static List<File> roots() {
        File[] roots = File.listRoots();
        if (roots == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(roots));
    }

    public static byte[] serialize(Object o) throws IOException {
        ByteArrayOutputStream aout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(aout);
        out.writeObject(o);
        out.close();
        return aout.toByteArray();
    }

    public static MessageDigest sha1Digester() {
        MessageDigest result;
        try {
            result = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Standard algorithm SHA-1 unavailable", e);
        }
        return result;
    }

    public static MessageDigest sha256Digester() {
        MessageDigest result;
        try {
            result = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Standard algorithm SHA-256 unavailable", e);
        }
        return result;
    }

    public static MessageDigest sha384Digester() {
        MessageDigest result;
        try {
            result = MessageDigest.getInstance("SHA-384");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Standard algorithm SHA-384 unavailable", e);
        }
        return result;
    }

    public static MessageDigest sha512Digester() {
        MessageDigest result;
        try {
            result = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Standard algorithm SHA-512 unavailable", e);
        }
        return result;
    }

    public static long skipFully(InputStream in, long count) throws IOException {
        return IO.copy(in, NULL, count);
    }

    public static long skipFully(Reader in, long count) throws IOException {
        return IO.copy(in, CNULL, count);
    }

    public static OutputStream transcode(String decode, String encode, OutputStream out) {
        if (decode == null || encode == null || decode.equals(encode)) {
            return out;
        }
        Charset dec = Charset.forName(decode);
        Charset enc = Charset.forName(encode);
        return IO.transcode(dec, enc, out);
    }

    public static OutputStream transcode(Charset decode, Charset encode, OutputStream out) {
        if (decode == null || encode == null || decode.equals(encode)) {
            return out;
        }
        return IO.transcode(decode.newDecoder(), encode.newEncoder(), out);
    }

    public static OutputStream transcode(CharsetDecoder decoder, CharsetEncoder encoder, OutputStream out) {
        if (decoder == null || encoder == null || decoder.charset().equals(encoder.charset())) {
            return out;
        }
        return new TranscodeOutputStream(decoder, encoder, out);
    }

    public static void unzip(File src, File dst) throws IOException {
        IO.unzipInternal(src, dst, false);
    }

    public static void unzipSync(File src, File dst) throws IOException {
        IO.unzipInternal(src, dst, true);
    }

    public static Charset utf16() {
        return Utf16Initializer.UTF16;
    }

    public static Charset utf16be() {
        return Utf16beInitializer.UTF16BE;
    }

    public static Charset utf16le() {
        return Utf16leInitializer.UTF16LE;
    }

    public static Charset utf8() {
        return Utf8Initializer.UTF8;
    }

    public static void writeChar(OutputStream out, ByteOrder order, char value) throws IOException {
        IO.writeShort(out, order, (short)value);
    }

    public static void writeChar(OutputStream out, char value) throws IOException {
        IO.writeChar(out, ByteOrder.BIG_ENDIAN, value);
    }

    public static void writeDouble(OutputStream out, ByteOrder order, double value) throws IOException {
        IO.writeLong(out, order, Double.doubleToLongBits(value));
    }

    public static void writeDouble(OutputStream out, double value) throws IOException {
        IO.writeDouble(out, ByteOrder.BIG_ENDIAN, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] data) throws IOException {
        boolean exceptionInProgress = true;
        FileOutputStream out = new FileOutputStream(file);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            IO.copy((InputStream)in, (OutputStream)out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    public static void writeFloat(OutputStream out, ByteOrder order, float value) throws IOException {
        IO.writeInt(out, order, Float.floatToIntBits(value));
    }

    public static void writeFloat(OutputStream out, float value) throws IOException {
        IO.writeFloat(out, ByteOrder.BIG_ENDIAN, value);
    }

    public static void writeInt(OutputStream out, ByteOrder order, int value) throws IOException {
        byte[] buffer = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(order);
        bb.putInt(value);
        out.write(buffer);
    }

    public static void writeInt(OutputStream out, int value) throws IOException {
        IO.writeInt(out, ByteOrder.BIG_ENDIAN, value);
    }

    public static void writeLong(OutputStream out, ByteOrder order, long value) throws IOException {
        byte[] buffer = new byte[8];
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(order);
        bb.putLong(value);
        out.write(buffer);
    }

    public static void writeLong(OutputStream out, long value) throws IOException {
        IO.writeLong(out, ByteOrder.BIG_ENDIAN, value);
    }

    public static OutputStreamWriter writer(File file) throws FileNotFoundException {
        return IO.writer(new FileOutputStream(file));
    }

    public static OutputStreamWriter writer(File file, Charset charset) throws FileNotFoundException {
        return IO.writer((OutputStream)new FileOutputStream(file), charset);
    }

    public static OutputStreamWriter writer(File file, CharsetEncoder encoder) throws FileNotFoundException {
        return IO.writer((OutputStream)new FileOutputStream(file), encoder);
    }

    public static OutputStreamWriter writer(File file, String charsetName) throws FileNotFoundException {
        return IO.writer((OutputStream)new FileOutputStream(file), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStreamWriter writer(OutputStream out) {
        OutputStreamWriter result;
        boolean exceptionInProgress = true;
        try {
            result = new OutputStreamWriter(out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStreamWriter writer(OutputStream out, Charset charset) {
        OutputStreamWriter result;
        if (charset == null) {
            result = IO.writer(out);
        } else {
            CharsetEncoder encoder;
            boolean exceptionInProgress = true;
            try {
                encoder = charset.newEncoder();
                exceptionInProgress = false;
            }
            finally {
                IO.closeOnException(out, exceptionInProgress);
            }
            result = IO.writer(out, encoder);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStreamWriter writer(OutputStream out, CharsetEncoder encoder) {
        OutputStreamWriter result;
        if (encoder == null) {
            result = IO.writer(out);
        } else {
            boolean exceptionInProgress = true;
            try {
                result = new OutputStreamWriter(out, encoder);
                exceptionInProgress = false;
            }
            finally {
                IO.closeOnException(out, exceptionInProgress);
            }
        }
        return result;
    }

    public static OutputStreamWriter writer(OutputStream out, String charset) {
        OutputStreamWriter result = charset == null ? IO.writer(out) : IO.writer(out, Charset.forName(charset));
        return result;
    }

    public static void writeShort(OutputStream out, ByteOrder order, short value) throws IOException {
        byte[] buffer = new byte[2];
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(order);
        bb.putShort(value);
        out.write(buffer);
    }

    public static void writeShort(OutputStream out, short value) throws IOException {
        IO.writeShort(out, ByteOrder.BIG_ENDIAN, value);
    }

    public static void writeText(OutputStream out, CharSequence sequence) throws IOException {
        OutputStreamWriter writer = IO.writer(out);
        IO.writeText(writer, sequence);
        writer.flush();
    }

    public static void writeText(OutputStream out, CharSequence sequence, Charset charset) throws IOException {
        OutputStreamWriter writer = IO.writer(out, charset);
        IO.writeText(writer, sequence);
        writer.flush();
    }

    public static void writeText(OutputStream out, CharSequence sequence, CharsetEncoder encoder) throws IOException {
        OutputStreamWriter writer = IO.writer(out, encoder);
        IO.writeText(writer, sequence);
        writer.flush();
    }

    public static void writeText(OutputStream out, CharSequence sequence, String charsetName) throws IOException {
        OutputStreamWriter writer = IO.writer(out, charsetName);
        IO.writeText(writer, sequence);
        writer.flush();
    }

    public static void writeText(Writer out, CharSequence sequence) throws IOException {
        IO.copy(IO.reader(sequence), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextAndClose(Writer out, String string) throws IOException {
        boolean exceptionInProgress = true;
        try {
            out.write(string);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    public static void writeTextFile(File file, String string) throws IOException {
        IO.writeTextAndClose(IO.writer(file), string);
    }

    public static void writeTextFile(File file, String string, Charset charset) throws IOException {
        IO.writeTextAndClose(IO.writer(file, charset), string);
    }

    public static void writeTextFile(File file, String string, CharsetEncoder encoder) throws IOException {
        IO.writeTextAndClose(IO.writer(file, encoder), string);
    }

    public static void writeTextFile(File file, String string, String charsetName) throws IOException {
        IO.writeTextAndClose(IO.writer(file, charsetName), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFileSync(File file, String string) throws IOException {
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer(new SyncFileOutputStream(file));
        try {
            IO.copy((Reader)IO.reader(string), out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    public static void writeTextFileSync(File file, String string, Charset charset) throws IOException {
        CharsetEncoder encoder = charset.newEncoder();
        IO.writeTextFileSync(file, string, encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFileSync(File file, String string, CharsetEncoder encoder) throws IOException {
        boolean exceptionInProgress = true;
        OutputStreamWriter out = IO.writer((OutputStream)new SyncFileOutputStream(file), encoder);
        try {
            IO.copy((Reader)IO.reader(string), out);
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(out, exceptionInProgress);
        }
    }

    public static void writeTextFileSync(File file, String string, String charsetName) throws IOException {
        Charset charset = Charset.forName(charsetName);
        IO.writeTextFileSync(file, string, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipInputStream zip(InputStream in) {
        ZipInputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new ZipInputStream(IO.buffer(in));
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(in, exceptionInProgress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipOutputStream zip(OutputStream out) {
        ZipOutputStream result;
        boolean exceptionInProgress = true;
        try {
            result = new ZipOutputStream(IO.buffer(out));
            exceptionInProgress = false;
        }
        finally {
            IO.closeOnException(out, exceptionInProgress);
        }
        return result;
    }

    private static void checkForDirectory(boolean created, File currentDir, File targetDir) throws IOException {
        String name = currentDir.getName();
        if (!created && !currentDir.isDirectory()) {
            char c;
            if (currentDir.isFile()) {
                if (currentDir == targetDir) {
                    throw new IOException(String.format("Unable to create directory %s: path is a file", targetDir.getAbsolutePath()));
                }
                throw new IOException(String.format("Unable to create directory %s: parent %s is a file", targetDir.getAbsolutePath(), currentDir.getAbsolutePath()));
            }
            if (File.separatorChar == '\\' && (c = IO.findInvalidWindowsFilenameChar(name)) != '\u0000') {
                if (currentDir == targetDir) {
                    throw new IOException(String.format("Unable to create directory %s: name contains character (%s) that may not valid", targetDir.getAbsolutePath(), Character.valueOf(c)));
                }
                throw new IOException(String.format("Unable to create directory %s: name of parent %s contains character (%s) that may not valid", targetDir.getAbsolutePath(), Character.valueOf(c), currentDir.getAbsolutePath()));
            }
            if (currentDir == targetDir) {
                throw new IOException(String.format("Unable to create directory %s", targetDir.getAbsolutePath()));
            }
            throw new IOException(String.format("Unable to create directory %s: unable to create parent %s", targetDir.getAbsolutePath(), currentDir.getAbsolutePath()));
        }
    }

    private static void closeCloseable(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeNoThrowCloseable(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void closeOnException(Closeable closeable, boolean exceptionInProgress) {
        if (exceptionInProgress) {
            IO.closeNoThrow(closeable);
        }
    }

    private static char findInvalidWindowsFilenameChar(String name) {
        char result = '\u0000';
        for (int i = 0; i < WINDOWS_INVALID_FILENAME_CHARS.length(); ++i) {
            char c = WINDOWS_INVALID_FILENAME_CHARS.charAt(i);
            if (name.indexOf(c) == -1) continue;
            result = c;
            break;
        }
        return result;
    }

    private static boolean mkdir0(File dir) {
        String path = dir.getPath();
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        dir = new File(path);
        while (dir.getName().equals(".") && dir.getParentFile() != null) {
            dir = dir.getParentFile();
        }
        return dir.mkdir();
    }

    private static boolean mkdirs0(File dir, File targetDir, List<File> newFiles) throws IOException {
        boolean created;
        if (dir.exists()) {
            created = false;
        } else if (dir.mkdir()) {
            created = true;
            if (newFiles != null) {
                newFiles.add(dir);
            }
        } else {
            File canonFile = dir.getCanonicalFile();
            File parent = canonFile.getParentFile();
            if (parent != null) {
                created = IO.mkdirs0(parent, targetDir, newFiles);
                if (created && (created = canonFile.mkdir()) && newFiles != null) {
                    newFiles.add(dir);
                }
            } else {
                created = false;
            }
        }
        IO.checkForDirectory(created, dir, targetDir);
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipInternal(File src, File dst, boolean sync) throws IOException {
        boolean exceptionInProgress = true;
        ZipFile zip = new ZipFile(src);
        try {
            IO.mkdirs(dst);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                File file = new File(dst, entry.getName());
                if (entry.isDirectory()) {
                    IO.mkdirs(file);
                    continue;
                }
                File parent = file.getParentFile();
                if (parent != null) {
                    IO.mkdirs(parent);
                }
                boolean exceptionInProgress2 = true;
                InputStream in = zip.getInputStream(entry);
                try {
                    if (sync) {
                        IO.copySync(in, file);
                    } else {
                        IO.copy(in, file);
                    }
                    exceptionInProgress2 = false;
                }
                finally {
                    IO.closeSafely(in, exceptionInProgress2);
                }
            }
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely(zip, exceptionInProgress);
        }
    }

    private IO() {
        throw new UnsupportedOperationException();
    }

    @BridgeMethodsAdded
    private static final class Utf8Initializer {
        static final Charset UTF8 = Charset.forName("UTF-8");

        private Utf8Initializer() {
        }
    }

    @BridgeMethodsAdded
    private static final class Utf16leInitializer {
        static final Charset UTF16LE = Charset.forName("UTF-16LE");

        private Utf16leInitializer() {
        }
    }

    @BridgeMethodsAdded
    private static final class Utf16Initializer {
        static final Charset UTF16 = Charset.forName("UTF-16");

        private Utf16Initializer() {
        }
    }

    @BridgeMethodsAdded
    private static final class Utf16beInitializer {
        static final Charset UTF16BE = Charset.forName("UTF-16BE");

        private Utf16beInitializer() {
        }
    }

    @BridgeMethodsAdded
    private static final class PwdInitializer {
        static final File pwd;

        private PwdInitializer() {
        }

        static {
            File file = new File(".");
            String path = file.getAbsolutePath();
            path = path.substring(0, path.length() - 1);
            boolean pathIsARoot = false;
            for (File root : IO.roots()) {
                if (!root.getPath().equals(path)) continue;
                pathIsARoot = true;
                break;
            }
            if (!pathIsARoot) {
                path = path.substring(0, path.length() - 1);
            }
            pwd = new File(path);
        }
    }

    @BridgeMethodsAdded
    private static final class NoCloseWriter
    extends Writer {
        private final Writer delegate;
        private volatile boolean open = true;

        NoCloseWriter(Writer delegate) {
            this.delegate = Check.nonNull(delegate, "delegate");
        }

        public Writer append(char charValue) throws IOException {
            this.checkIsOpen();
            return this.delegate.append(charValue);
        }

        public Writer append(CharSequence charSequence) throws IOException {
            this.checkIsOpen();
            return this.delegate.append(charSequence);
        }

        public Writer append(CharSequence charSequence, int start, int end) throws IOException {
            this.checkIsOpen();
            return this.delegate.append(charSequence, start, end);
        }

        public void close() throws IOException {
            this.open = false;
        }

        public void flush() throws IOException {
            this.checkIsOpen();
            this.delegate.flush();
        }

        public void write(char[] buffer) throws IOException {
            this.checkIsOpen();
            this.delegate.write(buffer);
        }

        public void write(char[] buffer, int offset, int length) throws IOException {
            this.checkIsOpen();
            this.delegate.write(buffer, offset, length);
        }

        public void write(int charValue) throws IOException {
            this.checkIsOpen();
            this.delegate.write(charValue);
        }

        public void write(String str) throws IOException {
            this.checkIsOpen();
            this.delegate.write(str);
        }

        public void write(String str, int off, int len) throws IOException {
            this.checkIsOpen();
            this.delegate.write(str, off, len);
        }

        private void checkIsOpen() throws IOException {
            if (!this.open) {
                throw new IOException("Closed");
            }
        }
    }

    @BridgeMethodsAdded
    private static final class NoClosePrintWriter
    extends PrintWriter {
        private volatile boolean open = true;

        NoClosePrintWriter(Writer delegate) {
            super(delegate);
        }

        public PrintWriter append(char charValue) {
            this.checkIsOpen();
            return super.append(charValue);
        }

        public PrintWriter append(CharSequence charSequence) {
            this.checkIsOpen();
            return super.append(charSequence);
        }

        public PrintWriter append(CharSequence charSequence, int start, int end) {
            this.checkIsOpen();
            return super.append(charSequence, start, end);
        }

        public void close() {
            this.open = false;
        }

        public void flush() {
            this.checkIsOpen();
            super.flush();
        }

        public void write(char[] buffer) {
            this.checkIsOpen();
            super.write(buffer);
        }

        public void write(char[] buffer, int offset, int length) {
            this.checkIsOpen();
            super.write(buffer, offset, length);
        }

        public void write(int charValue) {
            this.checkIsOpen();
            super.write(charValue);
        }

        public void write(String str) {
            this.checkIsOpen();
            super.write(str);
        }

        public void write(String str, int off, int len) {
            this.checkIsOpen();
            super.write(str, off, len);
        }

        private void checkIsOpen() {
            if (!this.open) {
                this.setError();
            }
        }
    }

    @BridgeMethodsAdded
    private static final class NoClosePrintStream
    extends PrintStream {
        private volatile boolean open = true;

        NoClosePrintStream(PrintStream delegate) {
            super(delegate);
        }

        public void close() {
            this.open = false;
        }

        public void flush() {
            this.checkIsOpen();
            super.flush();
        }

        public void write(byte[] buffer) throws IOException {
            this.checkIsOpen();
            super.write(buffer);
        }

        public void write(byte[] buffer, int offset, int length) {
            this.checkIsOpen();
            super.write(buffer, offset, length);
        }

        public void write(int byteValue) {
            this.checkIsOpen();
            super.write(byteValue);
        }

        private void checkIsOpen() {
            if (!this.open) {
                this.setError();
            }
        }
    }

    @BridgeMethodsAdded
    private static final class NoCloseOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private volatile boolean open = true;

        NoCloseOutputStream(OutputStream delegate) {
            this.delegate = Check.nonNull(delegate, "delegate");
        }

        public void close() throws IOException {
            this.open = false;
        }

        public void flush() throws IOException {
            this.checkIsOpen();
            this.delegate.flush();
        }

        public void write(byte[] buffer) throws IOException {
            this.checkIsOpen();
            this.delegate.write(buffer);
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            this.checkIsOpen();
            this.delegate.write(buffer, offset, length);
        }

        public void write(int byteValue) throws IOException {
            this.checkIsOpen();
            this.delegate.write(byteValue);
        }

        private void checkIsOpen() throws IOException {
            if (!this.open) {
                throw new IOException("Closed");
            }
        }
    }

    @BridgeMethodsAdded
    private static final class MultiplexOutputStream
    extends OutputStream {
        private final OutputStream[] delegates;

        public MultiplexOutputStream(OutputStream first, OutputStream ... rest) {
            Check.nonNull(first, "first");
            Check.nonNull(rest, "rest");
            rest = (OutputStream[])rest.clone();
            Check.allNonNull(rest, "rest");
            this.delegates = new OutputStream[1 + rest.length];
            this.delegates[0] = first;
            System.arraycopy(rest, 0, this.delegates, 1, rest.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            boolean exceptionInProgress = true;
            try {
                this.flush();
                exceptionInProgress = false;
            }
            catch (Throwable throwable) {
                this.doAll(0, exceptionInProgress, new IOOperation(){

                    public void run(OutputStream delegate) throws IOException {
                        delegate.close();
                    }
                });
                throw throwable;
            }
            this.doAll(0, exceptionInProgress, new /* invalid duplicate definition of identical inner class */);
        }

        public void flush() throws IOException {
            this.doAll(0, false, new IOOperation(){

                public void run(OutputStream delegate) throws IOException {
                    delegate.flush();
                }
            });
        }

        public void write(final byte[] buffer) throws IOException {
            Check.nonNull(buffer);
            this.doAll(0, false, new IOOperation(){

                public void run(OutputStream delegate) throws IOException {
                    delegate.write(buffer);
                }
            });
        }

        public void write(final byte[] buffer, final int offset, final int length) throws IOException {
            Check.nonNull(buffer);
            Check.indexRange(buffer.length, offset, length);
            this.doAll(0, false, new IOOperation(){

                public void run(OutputStream delegate) throws IOException {
                    delegate.write(buffer, offset, length);
                }
            });
        }

        public void write(final int byteValue) throws IOException {
            this.doAll(0, false, new IOOperation(){

                public void run(OutputStream delegate) throws IOException {
                    delegate.write(byteValue);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAll(int start, boolean exceptionInProgress, IOOperation operation) throws IOException {
            if (start < this.delegates.length) {
                boolean localExceptionInProgress = true;
                try {
                    OutputStream delegate = this.delegates[start];
                    if (exceptionInProgress) {
                        try {
                            operation.run(delegate);
                        }
                        catch (Throwable swallow) {}
                    } else {
                        operation.run(delegate);
                    }
                    localExceptionInProgress = false;
                    this.doAll(start + 1, localExceptionInProgress || exceptionInProgress, operation);
                }
                catch (Throwable throwable) {
                    this.doAll(start + 1, localExceptionInProgress || exceptionInProgress, operation);
                    throw throwable;
                }
            }
        }

        @BridgeMethodsAdded
        private static interface IOOperation {
            public void run(OutputStream var1) throws IOException;
        }
    }

    @BridgeMethodsAdded
    private static final class LimitedInputStream
    extends InputStream {
        private final long limit;
        private final InputStream delegate;
        private long position;
        private boolean closed;

        private LimitedInputStream(long limit, InputStream delegate) {
            this.limit = limit;
            this.delegate = delegate;
        }

        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                if (this.position < this.limit) {
                    IO.discard(this.delegate, this.limit - this.position);
                }
            }
        }

        public synchronized int read() throws IOException {
            int result;
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.position >= this.limit) {
                result = -1;
            } else {
                result = this.delegate.read();
                if (result != -1) {
                    ++this.position;
                }
            }
            return result;
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int result;
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.position >= this.limit) {
                result = -1;
            } else {
                if ((long)len > this.limit - this.position) {
                    len = (int)(this.limit - this.position);
                }
                if ((result = this.delegate.read(b, off, len)) != -1) {
                    this.position += (long)result;
                }
            }
            return result;
        }
    }

    @BridgeMethodsAdded
    private static final class Latin1Initializer {
        static final Charset LATIN1 = Charset.forName("ISO-8859-1");

        private Latin1Initializer() {
        }
    }

    @BridgeMethodsAdded
    private static final class AsciiInitializer {
        static final Charset ASCII = Charset.forName("US-ASCII");

        private AsciiInitializer() {
        }
    }
}

